/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.inventory.craft;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.compat.VersionHandler;
import ru.endlesscode.rpginventory.event.listener.CraftListener;
import ru.endlesscode.rpginventory.inventory.craft.CraftExtension;
import ru.endlesscode.rpginventory.item.Texture;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.utils.Log;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class CraftManager {
    @NotNull
    private static final List<CraftExtension> EXTENSIONS = new ArrayList<CraftExtension>();
    private static Texture textureOfExtendable;

    private CraftManager() {
    }

    public static boolean init(@NotNull RPGInventory rPGInventory) {
        MemorySection memorySection = (MemorySection)Config.getConfig().get("craft");
        if (memorySection == null) {
            Log.w("Section ''craft'' not found in config.yml", new Object[0]);
            return false;
        }
        if (!memorySection.getBoolean("enabled")) {
            Log.i("Craft system is disabled in config", new Object[0]);
            return false;
        }
        try {
            Texture texture = Texture.parseTexture(memorySection.getString("extendable"));
            if (texture.isEmpty()) {
                Log.s("Invalid texture in ''craft.extendable''", new Object[0]);
                return false;
            }
            textureOfExtendable = texture;
            @Nullable ConfigurationSection configurationSection = memorySection.getConfigurationSection("extensions");
            if (configurationSection == null) {
                Log.s("Section ''craft.extensions'' not found in config.yml", new Object[0]);
                return false;
            }
            EXTENSIONS.clear();
            for (String string : configurationSection.getKeys(false)) {
                EXTENSIONS.add(new CraftExtension(string, configurationSection.getConfigurationSection(string)));
            }
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new CraftListener((Plugin)rPGInventory));
            if (VersionHandler.getVersionCode() >= 11200) {
                CraftManager.disableRecipeBook();
            }
            return true;
        }
        catch (Exception exception) {
            rPGInventory.getReporter().report("Error on CraftManager initialization", exception);
            return false;
        }
    }

    private static void disableRecipeBook() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)RPGInventory.getInstance(), new PacketType[]{PacketType.Play.Server.RECIPES}){

            public void onPacketSending(@NotNull PacketEvent packetEvent) {
                packetEvent.setCancelled(true);
            }
        });
        Log.i("Recipe book conflicts with craft extensions and was disabled", new Object[0]);
    }

    @NotNull
    public static List<CraftExtension> getExtensions(Player player) {
        ArrayList<CraftExtension> arrayList = new ArrayList<CraftExtension>(EXTENSIONS);
        for (CraftExtension craftExtension : EXTENSIONS) {
            if (!craftExtension.isUnlockedForPlayer(player)) continue;
            craftExtension.registerExtension(arrayList);
        }
        return arrayList;
    }

    public static Texture getTextureOfExtendable() {
        return textureOfExtendable;
    }

    @Nullable
    static CraftExtension getByName(String string) {
        for (CraftExtension craftExtension : EXTENSIONS) {
            if (!craftExtension.getName().equals(string)) continue;
            return craftExtension;
        }
        return null;
    }
}

