/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.inventory.craft;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.inventory.craft.CraftManager;
import ru.endlesscode.rpginventory.utils.StringUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class CraftExtension {
    private final String name;
    private final ItemStack capItem;
    private final List<Integer> slots;
    @Nullable
    private final List<CraftExtension> includes;

    CraftExtension(String string, ConfigurationSection configurationSection) {
        this.name = string;
        this.capItem = this.initCapItem(configurationSection);
        this.slots = configurationSection.getIntegerList("slots");
        if (configurationSection.contains("includes")) {
            this.includes = new ArrayList<CraftExtension>();
            for (String string2 : configurationSection.getStringList("includes")) {
                CraftExtension craftExtension = CraftManager.getByName(string2);
                if (craftExtension == null) continue;
                this.includes.add(craftExtension);
            }
        } else {
            this.includes = null;
        }
    }

    private ItemStack initCapItem(@NotNull ConfigurationSection configurationSection) {
        ItemStack itemStack = CraftManager.getTextureOfExtendable().getItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(StringUtils.coloredLine(configurationSection.getString("name", this.name)));
            if (configurationSection.contains("lore")) {
                itemMeta.setLore(StringUtils.coloredLines(configurationSection.getStringList("lore")));
            }
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    public ItemStack getCapItem() {
        return this.capItem;
    }

    public String getName() {
        return this.name;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    boolean isUnlockedForPlayer(@NotNull Player player) {
        return RPGInventory.getPermissions().has(player, "rpginventory.craft." + this.name);
    }

    void registerExtension(@NotNull List<CraftExtension> list) {
        list.remove(this);
        if (this.includes == null) {
            return;
        }
        for (CraftExtension craftExtension : this.includes) {
            craftExtension.registerExtension(list);
        }
    }
}

