/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.inventory.backpack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.inventory.backpack.Backpack;
import ru.endlesscode.rpginventory.item.Texture;
import ru.endlesscode.rpginventory.item.TexturedItem;
import ru.endlesscode.rpginventory.misc.FileLanguage;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.StringUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class BackpackType
extends TexturedItem {
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final List<String> lore;
    private final int size;
    private ItemStack item;

    BackpackType(Texture texture, ConfigurationSection configurationSection) {
        super(texture);
        this.id = configurationSection.getName();
        this.name = StringUtils.coloredLine(configurationSection.getString("name", this.id));
        this.lore = StringUtils.coloredLines(configurationSection.getStringList("lore"));
        this.size = configurationSection.getInt("size", 56) < 56 ? configurationSection.getInt("size") : 56;
        this.createItem();
    }

    private void createItem() {
        ItemStack itemStack = this.texture.getItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(this.name);
            FileLanguage fileLanguage = RPGInventory.getLanguage();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList(fileLanguage.getMessage("backpack.desc").split("\n")));
            arrayList.addAll(this.lore);
            arrayList.add(fileLanguage.getMessage("backpack.size", this.size));
            itemMeta.setLore(arrayList);
            itemStack.setItemMeta(itemMeta);
        }
        this.item = ItemUtils.setTag(itemStack, "backpack.id", this.id);
    }

    @NotNull
    Backpack createBackpack(UUID uUID) {
        return new Backpack(this, uUID);
    }

    @NotNull
    Backpack createBackpack() {
        return new Backpack(this);
    }

    public int getSize() {
        return this.size;
    }

    @NotNull
    String getTitle() {
        return this.name;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public String getId() {
        return this.id;
    }
}

