/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.inventory.backpack;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.event.listener.BackpackListener;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.backpack.Backpack;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackType;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.item.Texture;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.misc.serialization.Serialization;
import ru.endlesscode.rpginventory.utils.FileUtils;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.Log;
import shade.ru.endlesscode.rpginventory.annotations.Contract;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;
import shade.ru.endlesscode.rpginventory.inspector.report.Reporter;

public class BackpackManager {
    private static final String CONFIG_NAME = "backpacks.yml";
    private static final HashMap<String, BackpackType> BACKPACK_TYPES = new HashMap();
    private static final HashMap<UUID, Backpack> BACKPACKS = new HashMap();
    private static int BACKPACK_LIMIT;
    private static Reporter reporter;

    public static boolean init(@NotNull RPGInventory rPGInventory) {
        if (!BackpackManager.isEnabled()) {
            Log.i("Slot for backpacks not found", new Object[0]);
            return false;
        }
        reporter = rPGInventory.getReporter();
        try {
            YamlConfiguration yamlConfiguration;
            ConfigurationSection configurationSection;
            Path path = RPGInventory.getInstance().getDataPath().resolve(CONFIG_NAME);
            if (Files.notExists(path, new LinkOption[0])) {
                RPGInventory.getInstance().saveResource(CONFIG_NAME, false);
            }
            if ((configurationSection = (yamlConfiguration = YamlConfiguration.loadConfiguration((File)path.toFile())).getConfigurationSection("backpacks")) == null) {
                Log.s("Section ''backpacks'' not found in {0}", CONFIG_NAME);
                return false;
            }
            BACKPACK_TYPES.clear();
            for (String string : configurationSection.getKeys(false)) {
                ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection(string);
                if (configurationSection2 == null) continue;
                BackpackManager.tryToAddBackpack(string, configurationSection2);
            }
            if (BACKPACK_TYPES.isEmpty()) {
                Log.i("No one backpack type found", new Object[0]);
                return false;
            }
            BACKPACKS.clear();
            BackpackManager.loadBackpacks();
            Log.i("{0} backpack type(s) has been loaded", BACKPACK_TYPES.size());
            Log.i("{0} backpack(s) has been loaded", BACKPACKS.size());
            BACKPACK_LIMIT = Config.getConfig().getInt("backpacks.limit", 0);
            rPGInventory.getServer().getPluginManager().registerEvents((Listener)new BackpackListener(), (Plugin)rPGInventory);
            return true;
        }
        catch (Exception exception) {
            reporter.report("Error on BackpackManager initialization", exception);
            return false;
        }
    }

    private static void tryToAddBackpack(String string, @NotNull ConfigurationSection configurationSection) {
        try {
            Texture texture = Texture.parseTexture(configurationSection.getString("item"));
            if (texture.isEmpty()) {
                Log.s("Backpack ''{0}'' has not been added because its item is not valid.", string);
                return;
            }
            BackpackType backpackType = new BackpackType(texture, configurationSection);
            BACKPACK_TYPES.put(string, backpackType);
        }
        catch (Exception exception) {
            Log.s("Backpack ''{0}'' can''t be added: {1}", string, exception.toString());
            Log.d(exception);
        }
    }

    private static boolean isEnabled() {
        return SlotManager.instance().getBackpackSlot() != null;
    }

    @NotNull
    public static List<String> getBackpackList() {
        return new ArrayList<String>(BACKPACK_TYPES.keySet());
    }

    @NotNull
    public static ItemStack getItem(String string) {
        BackpackType backpackType = BACKPACK_TYPES.get(string);
        return backpackType == null ? new ItemStack(Material.AIR) : backpackType.getItem();
    }

    @Contract(value="_, null -> false")
    public static boolean open(@NotNull Player player, @Nullable ItemStack itemStack) {
        Backpack backpack;
        UUID uUID;
        BackpackType backpackType;
        if (ItemUtils.isEmpty(itemStack)) {
            return false;
        }
        String string = ItemUtils.getTag(itemStack, "backpack.id");
        if (string.isEmpty() || (backpackType = BackpackManager.getBackpackType(string)) == null) {
            return false;
        }
        String string2 = ItemUtils.getTag(itemStack, "backpack.uid");
        UUID uUID2 = uUID = string2.isEmpty() ? null : UUID.fromString(string2);
        if (!BACKPACKS.containsKey(uUID)) {
            if (uUID == null) {
                backpack = backpackType.createBackpack();
                ItemUtils.setTag(itemStack, "backpack.uid", backpack.getUniqueId().toString());
            } else {
                backpack = backpackType.createBackpack(uUID);
            }
            BACKPACKS.put(backpack.getUniqueId(), backpack);
        } else {
            backpack = BACKPACKS.get(uUID);
        }
        backpack.open(player);
        return true;
    }

    @Nullable
    public static BackpackType getBackpackType(String string) {
        return BACKPACK_TYPES.get(string);
    }

    public static void saveBackpacks() {
        Path path = RPGInventory.getInstance().getDataPath().resolve("backpacks");
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            for (Map.Entry<UUID, Backpack> entry : BACKPACKS.entrySet()) {
                Path path2 = path.resolve(entry.getKey().toString() + ".bp");
                Serialization.save(entry.getValue(), path2);
            }
        }
        catch (IOException iOException) {
            reporter.report("Error on backpack save", iOException);
        }
    }

    private static void loadBackpacks() {
        try {
            Path path2 = RPGInventory.getInstance().getDataPath().resolve("backpacks");
            Files.createDirectories(path2, new FileAttribute[0]);
            Files.list(path2).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".bp")).forEach(BackpackManager::tryToLoadBackpack);
        }
        catch (IOException iOException) {
            reporter.report("Error on backpacks loading", iOException);
        }
    }

    private static void tryToLoadBackpack(@NotNull Path path) {
        try {
            BackpackManager.loadBackpack(path);
        }
        catch (IOException | InvalidConfigurationException throwable) {
            Log.d(throwable);
            FileUtils.resolveException(path);
            Log.s("Error on loading backpack {0}", path.getFileName().toString());
            Log.s("Will be created new backpack. Old file was renamed.", new Object[0]);
        }
    }

    private static void loadBackpack(@NotNull Path path) {
        Backpack backpack = Serialization.loadBackpack(path);
        if (backpack == null || backpack.isOverdue()) {
            Files.delete(path);
        } else {
            BACKPACKS.put(backpack.getUniqueId(), backpack);
        }
    }

    @Contract(value="null -> false")
    public static boolean isBackpack(ItemStack itemStack) {
        return ItemUtils.isNotEmpty(itemStack) && ItemUtils.hasTag(itemStack, "backpack.id");
    }

    public static boolean backpackLimitReached(@NotNull Player player) {
        if (BACKPACK_LIMIT == 0) {
            return false;
        }
        PlayerInventory playerInventory = player.getInventory();
        int n = 0;
        for (ItemStack itemStack : playerInventory.getContents()) {
            if (!BackpackManager.isBackpack(itemStack)) continue;
            ++n;
        }
        playerInventory = InventoryManager.get((OfflinePlayer)player).getInventory();
        Slot slot = SlotManager.instance().getBackpackSlot();
        if (slot != null && BackpackManager.isBackpack(playerInventory.getItem(slot.getSlotId())) && !slot.isQuick()) {
            ++n;
        }
        return n >= BACKPACK_LIMIT;
    }

    public static int getLimit() {
        return BACKPACK_LIMIT;
    }
}

