/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.inventory.backpack;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackHolder;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackManager;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackType;
import ru.endlesscode.rpginventory.misc.config.Config;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class Backpack
implements ConfigurationSerializable {
    private static final String BP_ID = "id";
    private static final String BP_TYPE = "type";
    private static final String BP_CONTENTS = "contents";
    private static final String BP_LAST_USE = "last-use";
    private final UUID id;
    @NotNull
    private final BackpackType backpackType;
    private long lastUse;
    private ItemStack[] contents;

    public Backpack(@NotNull BackpackType backpackType) {
        this(backpackType, UUID.randomUUID());
    }

    public Backpack(@NotNull BackpackType backpackType, UUID uUID) {
        this.id = uUID;
        this.backpackType = backpackType;
        this.contents = new ItemStack[backpackType.getSize()];
    }

    @NotNull
    public static Backpack deserialize(@NotNull Map<String, Object> map) {
        UUID uUID = UUID.fromString((String)map.get(BP_ID));
        BackpackType backpackType = BackpackManager.getBackpackType((String)map.get(BP_TYPE));
        List<ItemStack> list = map.getOrDefault(BP_CONTENTS, Collections.emptyList());
        long l = (Long)map.getOrDefault(BP_LAST_USE, 0L);
        Backpack backpack = new Backpack(backpackType, uUID);
        backpack.setContents(list.toArray(new ItemStack[0]));
        backpack.setLastUse(l);
        return backpack;
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put(BP_ID, this.id.toString());
        linkedHashMap.put(BP_TYPE, this.backpackType.getId());
        linkedHashMap.put(BP_CONTENTS, this.contents);
        linkedHashMap.put(BP_LAST_USE, this.lastUse);
        return linkedHashMap;
    }

    UUID getUniqueId() {
        return this.id;
    }

    @NotNull
    public BackpackType getType() {
        return this.backpackType;
    }

    void open(@NotNull Player player) {
        int n = (int)Math.ceil((double)this.backpackType.getSize() / 9.0) * 9;
        BackpackHolder backpackHolder = new BackpackHolder();
        Inventory inventory = Bukkit.createInventory((InventoryHolder)backpackHolder, (int)n, (String)this.backpackType.getTitle());
        backpackHolder.setInventory(inventory);
        for (int i = 0; i < n; ++i) {
            if (i < this.backpackType.getSize()) {
                if (this.contents[i] == null) continue;
                inventory.setItem(i, this.contents[i]);
                continue;
            }
            inventory.setItem(i, InventoryManager.getFillSlot());
        }
        player.openInventory(inventory);
        InventoryManager.get((OfflinePlayer)player).setBackpack(this);
    }

    public void setContents(ItemStack[] itemStackArray) {
        this.contents = itemStackArray;
    }

    public void onUse() {
        this.lastUse = System.currentTimeMillis();
    }

    public void setLastUse(long l) {
        this.lastUse = l;
    }

    boolean isOverdue() {
        int n = Config.getConfig().getInt("backpacks.expiration-time", 0);
        return n != 0 && (System.currentTimeMillis() - this.lastUse) / 86400000L > (long)n;
    }
}

