/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.event.updater.StatsUpdater;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.backpack.Backpack;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.item.CustomItem;
import ru.endlesscode.rpginventory.item.ItemManager;
import ru.endlesscode.rpginventory.misc.serialization.InventorySnapshot;
import ru.endlesscode.rpginventory.pet.Attributes;
import ru.endlesscode.rpginventory.pet.PetManager;
import ru.endlesscode.rpginventory.pet.PetType;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.Log;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.scheduler.TrackedBukkitRunnable;

public class PlayerWrapper
implements InventoryHolder {
    private final OfflinePlayer player;
    private final Inventory inventory;
    private final Map<String, Integer> buyedSlots = new HashMap<String, Integer>();
    private final List<String> permissions = new ArrayList<String>();
    @Nullable
    private InventoryView inventoryView;
    @Nullable
    private Slot slotPreparedToBuy = null;
    private long timeWhenPreparedToBuy = 0L;
    @Nullable
    private Backpack backpack = null;
    private LivingEntity pet;
    @Nullable
    private ItemStack savedChestplate = null;
    private boolean falling = false;
    private boolean flying = false;
    private int fallTime = 0;
    private String lastMessage = "";
    private long lastMessageTime = 0L;
    private boolean pocketCraft = false;

    public PlayerWrapper(OfflinePlayer offlinePlayer) {
        this.player = offlinePlayer;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)InventoryManager.TITLE);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Nullable
    public InventoryView getInventoryView() {
        return this.inventoryView;
    }

    public void openInventoryDeferred(final boolean bl) {
        new TrackedBukkitRunnable(){

            public void run() {
                PlayerWrapper.this.openInventory(bl);
            }
        }.runTaskLater((Plugin)RPGInventory.getInstance(), 0L);
    }

    public void openInventory() {
        this.openInventory(false);
    }

    public void openInventory(boolean bl) {
        Player player = this.player.getPlayer();
        if (player == null) {
            return;
        }
        if (!bl) {
            player.closeInventory();
        }
        this.inventoryView = player.getOpenInventory();
        player.openInventory(this.inventory);
    }

    void prepareToBuy(Slot slot) {
        this.slotPreparedToBuy = slot;
        this.timeWhenPreparedToBuy = System.currentTimeMillis();
    }

    public boolean isOpened() {
        return this.inventoryView != null;
    }

    public void onClose() {
        this.inventoryView = null;
    }

    public int getBuyedGenericSlots() {
        return this.buyedSlots.get("{generic}");
    }

    public void setBuyedSlots(int n) {
        this.setBuyedSlots("{generic}", n);
    }

    public void setBuyedSlots(String string) {
        this.setBuyedSlots(string, 1);
    }

    private void setBuyedSlots(String string, int n) {
        this.buyedSlots.put(string, n);
    }

    public boolean isBuyedSlot(String string) {
        return this.buyedSlots.containsKey(string);
    }

    boolean isPreparedToBuy(Slot slot) {
        if (this.timeWhenPreparedToBuy == 0L || this.slotPreparedToBuy != slot || System.currentTimeMillis() - this.timeWhenPreparedToBuy > 10000L) {
            return false;
        }
        this.timeWhenPreparedToBuy = 0L;
        this.slotPreparedToBuy = null;
        return true;
    }

    public void addPermissions(@NotNull List<String> list) {
        try {
            for (String string : list) {
                if (!RPGInventory.getPermissions().playerAdd(this.player.getPlayer(), string)) continue;
                this.permissions.add(string);
            }
        }
        catch (Exception exception) {
            Log.w(exception);
        }
    }

    private void clearPermissions() {
        try {
            for (String string : this.permissions) {
                RPGInventory.getPermissions().playerRemove(this.player.getPlayer(), string);
            }
            this.permissions.clear();
        }
        catch (Exception exception) {
            Log.w(exception);
        }
    }

    private void clearStats() {
        Player player = this.player.getPlayer();
        AttributeInstance attributeInstance = player.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        assert (attributeInstance != null);
        AttributeModifier attributeModifier = null;
        for (AttributeModifier attributeModifier2 : attributeInstance.getModifiers()) {
            if (attributeModifier2.getUniqueId().compareTo(Attributes.SPEED_MODIFIER_ID) != 0) continue;
            attributeModifier = attributeModifier2;
        }
        if (attributeModifier != null) {
            attributeInstance.removeModifier(attributeModifier);
        }
    }

    @Nullable
    public Backpack getBackpack() {
        return this.backpack;
    }

    public void setBackpack(@Nullable Backpack backpack) {
        this.backpack = backpack;
    }

    @Nullable
    public LivingEntity getPet() {
        return this.pet;
    }

    public void setPet(LivingEntity livingEntity) {
        this.pet = livingEntity;
    }

    public boolean hasPet() {
        return this.pet != null;
    }

    public OfflinePlayer getPlayer() {
        return this.player;
    }

    public void onFall() {
        if (this.isFalling()) {
            if (this.fallTime == 0) {
                this.startFlight();
            }
            ++this.fallTime;
        } else {
            this.setFalling(true);
        }
    }

    private void startFlight() {
        Slot slot = SlotManager.instance().getElytraSlot();
        if (slot == null) {
            return;
        }
        ItemStack itemStack = this.inventory.getItem(slot.getSlotId());
        if (!slot.isCup(itemStack)) {
            Player player = this.player.getPlayer();
            ItemStack itemStack2 = player.getEquipment().getChestplate();
            this.savedChestplate = ItemUtils.isEmpty(itemStack2) ? new ItemStack(Material.AIR) : itemStack2;
            player.getEquipment().setChestplate(this.inventory.getItem(slot.getSlotId()));
            this.flying = true;
        }
    }

    public void onStartGliding() {
        if (this.hasPet()) {
            PetManager.despawnPet(this.player);
        }
    }

    public boolean isFalling() {
        return this.falling;
    }

    public void setFalling(boolean bl) {
        if (!bl && this.flying) {
            this.stopFlight();
        }
        this.fallTime = 0;
        this.falling = bl;
    }

    private void stopFlight() {
        Slot slot = SlotManager.instance().getElytraSlot();
        if (this.savedChestplate != null && slot != null) {
            Player player = this.player.getPlayer();
            this.inventory.setItem(slot.getSlotId(), player.getEquipment().getChestplate());
            player.getEquipment().setChestplate(this.savedChestplate);
            this.savedChestplate = null;
        }
        this.flying = false;
        if (PetManager.isEnabled() && !this.hasPet()) {
            PetManager.respawnPet((OfflinePlayer)this.player.getPlayer());
        }
    }

    public boolean isFlying() {
        return this.flying;
    }

    @Nullable
    ItemStack getSavedChestplate() {
        return this.savedChestplate;
    }

    void onUnload() {
        if (this.flying) {
            this.setFalling(false);
        }
        this.clearStats();
        if (PetManager.isEnabled()) {
            PetManager.despawnPet(this.player);
            Inventory inventory = this.inventory;
            ItemStack itemStack = inventory.getItem(PetManager.getPetSlotId());
            if (itemStack != null) {
                inventory.setItem(PetManager.getPetSlotId(), PetType.clone(itemStack));
            }
        }
    }

    public void updateStatsLater() {
        new StatsUpdater(this.player.getPlayer()).runTaskLater((Plugin)RPGInventory.getInstance(), 1L);
    }

    public void updatePermissions() {
        Player player = this.player.getPlayer();
        this.clearPermissions();
        ArrayList<CustomItem> arrayList = new ArrayList<CustomItem>();
        for (ItemStack object : this.getInventory().getContents()) {
            if (!CustomItem.isCustomItem(object)) continue;
            arrayList.add(ItemManager.getCustomItem(object));
        }
        ItemStack itemStack = player.getEquipment().getItemInOffHand();
        ItemStack itemStack2 = player.getEquipment().getItemInMainHand();
        if (CustomItem.isCustomItem(itemStack)) {
            arrayList.add(ItemManager.getCustomItem(itemStack));
        }
        if (CustomItem.isCustomItem(itemStack2)) {
            arrayList.add(ItemManager.getCustomItem(itemStack2));
        }
        for (CustomItem customItem : arrayList) {
            customItem.onEquip(player);
        }
    }

    public String getLastMessage() {
        if (System.currentTimeMillis() - this.lastMessageTime > 5000L) {
            this.lastMessage = "";
        }
        return this.lastMessage;
    }

    public void setLastMessage(String string) {
        this.lastMessage = string;
        this.lastMessageTime = System.currentTimeMillis();
    }

    public void openWorkbench() {
        this.player.getPlayer().openWorkbench(null, true);
        this.pocketCraft = true;
    }

    public void onWorkbenchClosed() {
        this.pocketCraft = false;
    }

    public boolean isPocketCraft() {
        return this.pocketCraft;
    }

    InventorySnapshot createSnapshot() {
        return InventorySnapshot.create(this);
    }
}

