/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.inventory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.api.InventoryAPI;
import ru.endlesscode.rpginventory.event.PetEquipEvent;
import ru.endlesscode.rpginventory.event.PetUnequipEvent;
import ru.endlesscode.rpginventory.event.PlayerInventoryLoadEvent;
import ru.endlesscode.rpginventory.event.PlayerInventoryUnloadEvent;
import ru.endlesscode.rpginventory.event.listener.InventoryListener;
import ru.endlesscode.rpginventory.inventory.ActionType;
import ru.endlesscode.rpginventory.inventory.ArmorType;
import ru.endlesscode.rpginventory.inventory.InventoryLocker;
import ru.endlesscode.rpginventory.inventory.PlayerWrapper;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.item.ItemManager;
import ru.endlesscode.rpginventory.item.Texture;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.misc.serialization.Serialization;
import ru.endlesscode.rpginventory.pet.PetManager;
import ru.endlesscode.rpginventory.pet.PetType;
import ru.endlesscode.rpginventory.resourcepack.ResourcePackModule;
import ru.endlesscode.rpginventory.utils.EffectUtils;
import ru.endlesscode.rpginventory.utils.InventoryUtils;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.Log;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import ru.endlesscode.rpginventory.utils.SafeEnums;
import ru.endlesscode.rpginventory.utils.StringUtils;
import shade.ru.endlesscode.rpginventory.annotations.Contract;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;
import shade.ru.endlesscode.rpginventory.inspector.report.Reporter;

public class InventoryManager {
    static final String TITLE = RPGInventory.getLanguage().getMessage("title");
    private static final Map<UUID, PlayerWrapper> INVENTORIES = new HashMap<UUID, PlayerWrapper>();
    private static ItemStack FILL_SLOT = null;
    private static Reporter reporter;

    private InventoryManager() {
    }

    public static boolean init(@NotNull RPGInventory rPGInventory) {
        reporter = rPGInventory.getReporter();
        try {
            Texture texture = Texture.parseTexture(Config.getConfig().getString("fill"));
            FILL_SLOT = texture.getItemStack();
            ItemMeta itemMeta = FILL_SLOT.getItemMeta();
            if (itemMeta != null) {
                itemMeta.setDisplayName(" ");
                FILL_SLOT.setItemMeta(itemMeta);
            }
        }
        catch (Exception exception) {
            reporter.report("Error on InventoryManager initialization", exception);
            return false;
        }
        rPGInventory.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)rPGInventory);
        return true;
    }

    public static boolean validateUpdate(Player player, ActionType actionType, @NotNull Slot slot, ItemStack itemStack) {
        return actionType == ActionType.GET || actionType == ActionType.DROP || actionType == ActionType.SET && slot.isValidItem(itemStack) && ItemManager.allowedForPlayer(player, itemStack, true);
    }

    @NotNull
    public static ItemStack getFillSlot() {
        return FILL_SLOT;
    }

    public static boolean validatePet(Player player, InventoryAction inventoryAction, @Nullable ItemStack itemStack, @NotNull ItemStack itemStack2) {
        ActionType actionType = ActionType.getTypeOfAction(inventoryAction);
        if (ItemUtils.isNotEmpty(itemStack) && (actionType == ActionType.GET || inventoryAction == InventoryAction.SWAP_WITH_CURSOR || actionType == ActionType.DROP) && PetManager.getCooldown(itemStack) > 0) {
            return false;
        }
        if (actionType == ActionType.SET) {
            if (PetType.isPetItem(itemStack2) && ItemManager.allowedForPlayer(player, itemStack2, true)) {
                PetEquipEvent petEquipEvent = new PetEquipEvent(player, itemStack2);
                RPGInventory.getInstance().getServer().getPluginManager().callEvent((Event)petEquipEvent);
                if (petEquipEvent.isCancelled()) {
                    return false;
                }
                PetManager.respawnPet(petEquipEvent.getPlayer(), petEquipEvent.getPetItem());
                return true;
            }
        } else if (actionType == ActionType.GET || actionType == ActionType.DROP) {
            PetUnequipEvent petUnequipEvent = new PetUnequipEvent(player);
            RPGInventory.getInstance().getServer().getPluginManager().callEvent((Event)petUnequipEvent);
            PetManager.despawnPet((OfflinePlayer)petUnequipEvent.getPlayer());
            return true;
        }
        return false;
    }

    public static boolean validateArmor(Player player, InventoryAction inventoryAction, @NotNull Slot slot, ItemStack itemStack) {
        ActionType actionType = ActionType.getTypeOfAction(inventoryAction);
        return actionType != ActionType.OTHER && (actionType != ActionType.SET || slot.isValidItem(itemStack)) && ItemManager.allowedForPlayer(player, itemStack, true);
    }

    public static void updateShieldSlot(@NotNull Player player, @NotNull Inventory inventory, @NotNull Slot slot, int n, InventoryType.SlotType slotType, InventoryAction inventoryAction, ItemStack itemStack, @NotNull ItemStack itemStack2) {
        ActionType actionType = ActionType.getTypeOfAction(inventoryAction);
        if (actionType == ActionType.GET) {
            if (slot.isCup(itemStack)) {
                return;
            }
            if (slotType == InventoryType.SlotType.QUICKBAR && InventoryAPI.isRPGInventory(inventory)) {
                inventory.setItem(slot.getSlotId(), slot.getCup());
            } else {
                player.getEquipment().setItemInOffHand(new ItemStack(Material.AIR));
            }
        } else if (actionType == ActionType.SET) {
            if (slot.isCup(itemStack)) {
                itemStack = null;
                inventoryAction = InventoryAction.PLACE_ALL;
            }
            if (slotType == InventoryType.SlotType.QUICKBAR && InventoryAPI.isRPGInventory(inventory)) {
                inventory.setItem(slot.getSlotId(), itemStack2);
            } else {
                player.getEquipment().setItemInOffHand(itemStack2);
            }
        }
        InventoryManager.updateInventory(player, inventory, n, slotType, inventoryAction, itemStack, itemStack2);
    }

    public static void updateQuickSlot(@NotNull Player player, @NotNull Inventory inventory, @NotNull Slot slot, int n, InventoryType.SlotType slotType, InventoryAction inventoryAction, ItemStack itemStack, ItemStack itemStack2) {
        ActionType actionType = ActionType.getTypeOfAction(inventoryAction);
        if (actionType == ActionType.GET) {
            if (slot.isCup(itemStack)) {
                return;
            }
            if (player.getInventory().getHeldItemSlot() == slot.getQuickSlot()) {
                InventoryUtils.heldFreeSlot(player, slot.getQuickSlot(), InventoryUtils.SearchType.NEXT);
            }
            if (slotType == InventoryType.SlotType.QUICKBAR && InventoryAPI.isRPGInventory(inventory)) {
                inventory.setItem(slot.getSlotId(), slot.getCup());
            } else {
                player.getInventory().setItem(slot.getQuickSlot(), slot.getCup());
            }
            inventoryAction = InventoryAction.SWAP_WITH_CURSOR;
            itemStack2 = slot.getCup();
        } else if (actionType == ActionType.SET) {
            if (slot.isCup(itemStack)) {
                itemStack = null;
                inventoryAction = InventoryAction.PLACE_ALL;
            }
            if (slotType == InventoryType.SlotType.QUICKBAR && InventoryAPI.isRPGInventory(inventory)) {
                inventory.setItem(slot.getSlotId(), itemStack2);
            } else {
                player.getInventory().setItem(slot.getQuickSlot(), itemStack2);
            }
        }
        InventoryManager.updateInventory(player, inventory, n, slotType, inventoryAction, itemStack, itemStack2);
    }

    public static void updateArmor(@NotNull Player player, @NotNull Inventory inventory, @NotNull Slot slot, int n, InventoryAction inventoryAction, ItemStack itemStack, @NotNull ItemStack itemStack2) {
        ActionType actionType = ActionType.getTypeOfAction(inventoryAction);
        EntityEquipment entityEquipment = player.getEquipment();
        assert (entityEquipment != null);
        if (actionType == ActionType.SET || inventoryAction == InventoryAction.UNKNOWN) {
            switch (slot.getName()) {
                case "helmet": {
                    InventoryManager.updateInventory(player, inventory, n, inventoryAction, itemStack, itemStack2);
                    entityEquipment.setHelmet(inventory.getItem(n));
                    break;
                }
                case "chestplate": {
                    InventoryManager.updateInventory(player, inventory, n, inventoryAction, itemStack, itemStack2);
                    entityEquipment.setChestplate(inventory.getItem(n));
                    break;
                }
                case "leggings": {
                    InventoryManager.updateInventory(player, inventory, n, inventoryAction, itemStack, itemStack2);
                    entityEquipment.setLeggings(inventory.getItem(n));
                    break;
                }
                case "boots": {
                    InventoryManager.updateInventory(player, inventory, n, inventoryAction, itemStack, itemStack2);
                    entityEquipment.setBoots(inventory.getItem(n));
                }
            }
        } else if (actionType == ActionType.GET || actionType == ActionType.DROP) {
            InventoryManager.updateInventory(player, inventory, n, inventoryAction, itemStack, itemStack2);
            switch (slot.getName()) {
                case "helmet": {
                    entityEquipment.setHelmet(null);
                    break;
                }
                case "chestplate": {
                    entityEquipment.setChestplate(null);
                    break;
                }
                case "leggings": {
                    entityEquipment.setLeggings(null);
                    break;
                }
                case "boots": {
                    entityEquipment.setBoots(null);
                }
            }
        }
    }

    public static void syncArmor(PlayerWrapper playerWrapper) {
        Slot slot;
        ItemStack itemStack;
        Player player = (Player)playerWrapper.getPlayer();
        Inventory inventory = playerWrapper.getInventory();
        SlotManager slotManager = SlotManager.instance();
        EntityEquipment entityEquipment = player.getEquipment();
        assert (entityEquipment != null);
        if (ArmorType.HELMET.getSlot() != -1) {
            itemStack = entityEquipment.getHelmet();
            slot = slotManager.getSlot(ArmorType.HELMET.getSlot(), InventoryType.SlotType.CONTAINER);
            inventory.setItem(ArmorType.HELMET.getSlot(), ItemUtils.isEmpty(itemStack) && slot != null ? slot.getCup() : itemStack);
        }
        if (ArmorType.CHESTPLATE.getSlot() != -1) {
            itemStack = playerWrapper.getSavedChestplate();
            slot = itemStack == null ? entityEquipment.getChestplate() : itemStack;
            Slot slot2 = slotManager.getSlot(ArmorType.CHESTPLATE.getSlot(), InventoryType.SlotType.CONTAINER);
            inventory.setItem(ArmorType.CHESTPLATE.getSlot(), (ItemStack)(ItemUtils.isEmpty((ItemStack)slot) && slot2 != null ? slot2.getCup() : slot));
        }
        if (ArmorType.LEGGINGS.getSlot() != -1) {
            itemStack = entityEquipment.getLeggings();
            slot = slotManager.getSlot(ArmorType.LEGGINGS.getSlot(), InventoryType.SlotType.CONTAINER);
            inventory.setItem(ArmorType.LEGGINGS.getSlot(), ItemUtils.isEmpty(itemStack) && slot != null ? slot.getCup() : itemStack);
        }
        if (ArmorType.BOOTS.getSlot() != -1) {
            itemStack = entityEquipment.getBoots();
            slot = slotManager.getSlot(ArmorType.BOOTS.getSlot(), InventoryType.SlotType.CONTAINER);
            inventory.setItem(ArmorType.BOOTS.getSlot(), ItemUtils.isEmpty(itemStack) && slot != null ? slot.getCup() : itemStack);
        }
    }

    public static void syncQuickSlots(PlayerWrapper playerWrapper) {
        Player player = (Player)playerWrapper.getPlayer();
        for (Slot slot : SlotManager.instance().getQuickSlots()) {
            playerWrapper.getInventory().setItem(slot.getSlotId(), player.getInventory().getItem(slot.getQuickSlot()));
        }
    }

    public static void syncInfoSlots(PlayerWrapper playerWrapper) {
        Player player = (Player)playerWrapper.getPlayer();
        for (Slot slot : SlotManager.instance().getInfoSlots()) {
            ItemStack itemStack = slot.getCup();
            if (ItemUtils.isEmpty(itemStack)) continue;
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta != null) {
                ArrayList<String> arrayList = itemMeta.getLore();
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    arrayList.set(i, StringUtils.setPlaceholders(player, string));
                }
                itemMeta.setLore(arrayList);
                itemStack.setItemMeta(itemMeta);
            }
            playerWrapper.getInventory().setItem(slot.getSlotId(), itemStack);
        }
        player.updateInventory();
    }

    public static void syncShieldSlot(@NotNull PlayerWrapper playerWrapper) {
        Slot slot = SlotManager.instance().getShieldSlot();
        if (slot == null) {
            return;
        }
        Player player = (Player)playerWrapper.getPlayer();
        ItemStack itemStack = player.getEquipment().getItemInOffHand();
        playerWrapper.getInventory().setItem(slot.getSlotId(), ItemUtils.isEmpty(itemStack) ? slot.getCup() : itemStack);
    }

    private static void updateInventory(@NotNull Player player, @NotNull Inventory inventory, int n, InventoryAction inventoryAction, ItemStack itemStack, @NotNull ItemStack itemStack2) {
        InventoryManager.updateInventory(player, inventory, n, InventoryType.SlotType.CONTAINER, inventoryAction, itemStack, itemStack2);
    }

    private static void updateInventory(@NotNull Player player, @NotNull Inventory inventory, int n, InventoryType.SlotType slotType, InventoryAction inventoryAction, ItemStack itemStack, @NotNull ItemStack itemStack2) {
        if (ActionType.getTypeOfAction(inventoryAction) == ActionType.DROP) {
            return;
        }
        if (inventoryAction == InventoryAction.PLACE_ALL) {
            if (ItemUtils.isEmpty(itemStack)) {
                itemStack = itemStack2.clone();
            } else {
                itemStack.setAmount(itemStack.getAmount() + itemStack2.getAmount());
            }
            itemStack2 = null;
        } else if (inventoryAction == InventoryAction.PLACE_ONE) {
            if (ItemUtils.isEmpty(itemStack)) {
                itemStack = itemStack2.clone();
                itemStack.setAmount(1);
                itemStack2.setAmount(itemStack2.getAmount() - 1);
            } else if (itemStack.getMaxStackSize() < itemStack.getAmount() + 1) {
                itemStack.setAmount(itemStack.getAmount() + 1);
                itemStack2.setAmount(itemStack2.getAmount() - 1);
            }
        } else if (inventoryAction == InventoryAction.PLACE_SOME) {
            itemStack2.setAmount(itemStack.getMaxStackSize() - itemStack.getAmount());
            itemStack.setAmount(itemStack.getMaxStackSize());
        } else if (inventoryAction == InventoryAction.SWAP_WITH_CURSOR) {
            ItemStack itemStack3 = itemStack2.clone();
            itemStack2 = itemStack.clone();
            itemStack = itemStack3;
        } else if (inventoryAction == InventoryAction.PICKUP_ALL) {
            itemStack2 = itemStack.clone();
            itemStack = null;
        } else if (inventoryAction == InventoryAction.PICKUP_HALF) {
            ItemStack itemStack4 = itemStack.clone();
            if (itemStack.getAmount() % 2 == 0) {
                itemStack4.setAmount(itemStack4.getAmount() / 2);
                itemStack = itemStack4.clone();
                itemStack2 = itemStack4.clone();
            } else {
                itemStack = itemStack4.clone();
                itemStack.setAmount(itemStack4.getAmount() / 2);
                itemStack2 = itemStack4.clone();
                itemStack2.setAmount(itemStack4.getAmount() / 2 + 1);
            }
        } else if (inventoryAction == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            player.getInventory().addItem(new ItemStack[]{itemStack});
            itemStack = null;
        }
        if (slotType == InventoryType.SlotType.QUICKBAR) {
            if (n < 9) {
                player.getInventory().setItem(n, itemStack);
            }
        } else {
            inventory.setItem(n, itemStack);
        }
        player.setItemOnCursor(itemStack2);
        player.updateInventory();
    }

    static void lockEmptySlots(Player player) {
        InventoryManager.lockEmptySlots(INVENTORIES.get(player.getUniqueId()).getInventory());
    }

    public static void lockEmptySlots(Inventory inventory) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            Slot slot = SlotManager.instance().getSlot(i, InventoryType.SlotType.CONTAINER);
            if (slot == null) {
                inventory.setItem(i, FILL_SLOT);
                continue;
            }
            if (!ItemUtils.isEmpty(inventory.getItem(i))) continue;
            inventory.setItem(i, slot.getCup());
        }
    }

    static void unlockEmptySlots(Player player) {
        Inventory inventory = INVENTORIES.get(player.getUniqueId()).getInventory();
        for (int i = 0; i < inventory.getSize(); ++i) {
            Slot slot = SlotManager.instance().getSlot(i, InventoryType.SlotType.CONTAINER);
            if (slot != null && !slot.isCup(inventory.getItem(i))) continue;
            inventory.setItem(i, null);
        }
    }

    public static boolean isQuickSlot(int n) {
        return InventoryManager.getQuickSlot(n) != null;
    }

    @Nullable
    public static Slot getQuickSlot(int n) {
        for (Slot slot : SlotManager.instance().getQuickSlots()) {
            if (n != slot.getQuickSlot()) continue;
            return slot;
        }
        return null;
    }

    static void lockQuickSlots(@NotNull Player player) {
        for (Slot slot : SlotManager.instance().getQuickSlots()) {
            int n = slot.getQuickSlot();
            if (ItemUtils.isEmpty(player.getInventory().getItem(n))) {
                player.getInventory().setItem(n, slot.getCup());
            }
            if (player.getInventory().getHeldItemSlot() != n || !slot.isCup(player.getInventory().getItem(n))) continue;
            InventoryUtils.heldFreeSlot(player, n, InventoryUtils.SearchType.NEXT);
        }
    }

    static void unlockQuickSlots(@NotNull Player player) {
        for (Slot slot : SlotManager.instance().getQuickSlots()) {
            int n = slot.getQuickSlot();
            if (!slot.isCup(player.getInventory().getItem(n))) continue;
            player.getInventory().setItem(n, null);
        }
    }

    public static boolean isNewPlayer(@NotNull Player player) {
        Path path = RPGInventory.getInstance().getDataFolder().toPath();
        return Files.notExists(path.resolve("inventories/" + player.getUniqueId() + ".inv"), new LinkOption[0]);
    }

    public static void loadPlayerInventory(Player player) {
        if (!InventoryManager.isAllowedWorld(player.getWorld())) {
            INVENTORIES.remove(player.getUniqueId());
            return;
        }
        try {
            Path path = RPGInventory.getInstance().getDataPath();
            Path path2 = path.resolve("inventories");
            Files.createDirectories(path2, new FileAttribute[0]);
            Path path3 = path2.resolve(player.getUniqueId() + ".inv");
            PlayerWrapper playerWrapper = null;
            if (Files.exists(path3, new LinkOption[0]) && (playerWrapper = Serialization.loadPlayerOrNull(player, path3)) == null) {
                Log.s("Error on loading {0}''s inventory.", player.getName());
                Log.s("Will be created new inventory. Old file was renamed.", new Object[0]);
            }
            if (playerWrapper == null) {
                playerWrapper = new PlayerWrapper((OfflinePlayer)player);
                playerWrapper.setBuyedSlots(0);
            }
            PlayerInventoryLoadEvent.Pre pre = new PlayerInventoryLoadEvent.Pre(player);
            RPGInventory.getInstance().getServer().getPluginManager().callEvent((Event)pre);
            if (pre.isCancelled()) {
                return;
            }
            INVENTORIES.put(player.getUniqueId(), playerWrapper);
            InventoryLocker.lockSlots(player);
            PetManager.initPlayer(player);
            RPGInventory.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerInventoryLoadEvent.Post(player));
        }
        catch (IOException iOException) {
            reporter.report("Error on inventory load", iOException);
        }
    }

    public static void unloadPlayerInventory(@NotNull Player player) {
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        INVENTORIES.get(player.getUniqueId()).onUnload();
        InventoryManager.savePlayerInventory(player);
        InventoryLocker.unlockSlots(player);
        INVENTORIES.remove(player.getUniqueId());
        RPGInventory.getInstance().getServer().getPluginManager().callEvent((Event)new PlayerInventoryUnloadEvent.Post(player));
    }

    public static void savePlayerInventory(@NotNull Player player) {
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        PlayerWrapper playerWrapper = INVENTORIES.get(player.getUniqueId());
        try {
            Path path = RPGInventory.getInstance().getDataPath();
            Path path2 = path.resolve("inventories");
            Files.createDirectories(path2, new FileAttribute[0]);
            Path path3 = path2.resolve(player.getUniqueId() + ".inv");
            Files.deleteIfExists(path3);
            Serialization.save(playerWrapper.createSnapshot(), path3);
        }
        catch (IOException iOException) {
            reporter.report("Error on inventory save", iOException);
        }
    }

    @NotNull
    public static PlayerWrapper get(@NotNull OfflinePlayer offlinePlayer) {
        PlayerWrapper playerWrapper = INVENTORIES.get(offlinePlayer.getUniqueId());
        if (playerWrapper == null) {
            throw new IllegalStateException(offlinePlayer.getName() + "'s inventory should be initialized!");
        }
        return playerWrapper;
    }

    public static boolean isQuickEmptySlot(@Nullable ItemStack itemStack) {
        for (Slot slot : SlotManager.instance().getQuickSlots()) {
            if (!slot.isCup(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFilledSlot(@Nullable ItemStack itemStack) {
        return FILL_SLOT.equals((Object)itemStack);
    }

    public static boolean isEmptySlot(@Nullable ItemStack itemStack) {
        for (Slot slot : SlotManager.instance().getSlots()) {
            if (!slot.isCup(itemStack)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean playerIsLoaded(@Nullable AnimalTamer animalTamer) {
        return animalTamer != null && INVENTORIES.containsKey(animalTamer.getUniqueId());
    }

    public static boolean isAllowedWorld(@NotNull World world) {
        List list = Config.getConfig().getStringList("worlds.list");
        ListType listType = SafeEnums.valueOf(ListType.class, Config.getConfig().getString("worlds.mode"), "list type");
        if (listType != null) {
            switch (listType) {
                case BLACKLIST: {
                    return !list.contains(world.getName());
                }
                case WHITELIST: {
                    return list.contains(world.getName());
                }
            }
        }
        return true;
    }

    public static boolean buySlot(@NotNull Player player, PlayerWrapper playerWrapper, Slot slot) {
        double d = slot.getCost();
        if (!playerWrapper.isPreparedToBuy(slot)) {
            PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("error.buyable", slot.getCost()));
            playerWrapper.prepareToBuy(slot);
            return false;
        }
        if (!PlayerUtils.checkMoney(player, d) || !RPGInventory.getEconomy().withdrawPlayer((OfflinePlayer)player, d).transactionSuccess()) {
            return false;
        }
        playerWrapper.setBuyedSlots(slot.getName());
        PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("message.buyed"));
        return true;
    }

    public static void initPlayer(@NotNull Player player, boolean bl) {
        ResourcePackModule resourcePackModule = RPGInventory.getResourcePackModule();
        if (resourcePackModule != null) {
            resourcePackModule.loadResourcePack(player, bl);
        } else {
            if (!bl) {
                EffectUtils.showDefaultJoinMessage(player);
            }
            InventoryManager.loadPlayerInventory(player);
        }
        if (RPGInventory.getPermissions().has(player, "rpginventory.admin")) {
            RPGInventory.getInstance().checkUpdates(player);
        }
    }

    private static enum ListType {
        BLACKLIST,
        WHITELIST;

    }
}

