/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.inventory;

import java.util.ArrayList;
import java.util.Collections;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.event.listener.LockerListener;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.item.Texture;
import ru.endlesscode.rpginventory.misc.FileLanguage;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.Log;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import ru.endlesscode.rpginventory.utils.StringUtils;
import shade.ru.endlesscode.rpginventory.annotations.Contract;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public class InventoryLocker {
    private static ItemStack LOCKED_SLOT = null;
    private static ItemStack BUYABLE_SLOT = null;
    private static final String TAG = "locked";

    private InventoryLocker() {
    }

    public static boolean init(@NotNull RPGInventory rPGInventory) {
        if (!InventoryLocker.isEnabled()) {
            Log.i("Inventory lock system is disabled in config", new Object[0]);
            return false;
        }
        try {
            LOCKED_SLOT = InventoryLocker.initSlotItem(TAG);
            BUYABLE_SLOT = InventoryLocker.initSlotItem("buyable");
            if (ItemUtils.isEmpty(LOCKED_SLOT) || ItemUtils.isEmpty(BUYABLE_SLOT)) {
                return false;
            }
        }
        catch (Exception exception) {
            rPGInventory.getReporter().report("Error on InventoryLocker initialization", exception);
            return false;
        }
        rPGInventory.getServer().getPluginManager().registerEvents((Listener)new LockerListener(), (Plugin)rPGInventory);
        return true;
    }

    private static ItemStack initSlotItem(String string) {
        Texture texture = Texture.parseTexture(Config.getConfig().getString("slots." + string));
        ItemStack itemStack = texture.getItemStack();
        if (ItemUtils.isEmpty(itemStack)) {
            Log.s("Texture specified in ''slots.{0}'' must be valid and must not be AIR", string);
            return itemStack;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(RPGInventory.getLanguage().getMessage(string + ".name"));
            itemMeta.setLore(Collections.singletonList(RPGInventory.getLanguage().getMessage(string + ".lore")));
            itemStack.setItemMeta(itemMeta);
        }
        return InventoryLocker.addTag(itemStack);
    }

    private static boolean isEnabled() {
        return Config.getConfig().getBoolean("slots.enabled");
    }

    public static boolean buySlot(@NotNull Player player, int n) {
        FileConfiguration fileConfiguration = Config.getConfig();
        if (fileConfiguration.getBoolean("slots.money.enabled")) {
            if (!RPGInventory.economyConnected()) {
                return false;
            }
            EconomyResponse economyResponse = RPGInventory.getEconomy().withdrawPlayer((OfflinePlayer)player, fileConfiguration.getDouble("slots.money.cost.line" + n));
            if (!economyResponse.transactionSuccess()) {
                return false;
            }
        }
        if (fileConfiguration.getBoolean("slots.level.enabled") && fileConfiguration.getBoolean("slots.level.spend") && RPGInventory.getLevelSystem() == PlayerUtils.LevelSystem.EXP) {
            int n2 = player.getLevel() - fileConfiguration.getInt("slots.level.required.line" + n);
            if (0 > n2) {
                return false;
            }
            player.setLevel(n2);
        }
        return true;
    }

    @Contract(pure=true)
    public static int getLine(int n) {
        return (n - 9) / 9 + 1;
    }

    @NotNull
    public static ItemStack getBuyableSlotForLine(int n) {
        ItemStack itemStack = BUYABLE_SLOT.clone();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            ArrayList<String> arrayList = itemMeta.getLore();
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            FileLanguage fileLanguage = RPGInventory.getLanguage();
            FileConfiguration fileConfiguration = Config.getConfig();
            if (fileConfiguration.getBoolean("slots.money.enabled")) {
                arrayList.add(fileLanguage.getMessage("buyable.money", StringUtils.doubleToString(fileConfiguration.getDouble("slots.money.cost.line" + n))));
            }
            if (fileConfiguration.getBoolean("slots.level.enabled")) {
                arrayList.add(fileLanguage.getMessage("buyable.level", fileConfiguration.getInt("slots.level.required.line" + n)));
            }
            itemMeta.setLore(arrayList);
            itemStack.setItemMeta(itemMeta);
        }
        return InventoryLocker.addTag(itemStack);
    }

    @NotNull
    private static ItemStack addTag(ItemStack itemStack) {
        return ItemUtils.setTag(itemStack, TAG, "0");
    }

    public static boolean isLockedSlot(@Nullable ItemStack itemStack) {
        return InventoryLocker.isEnabled() && ItemUtils.isNotEmpty(itemStack) && ItemUtils.hasTag(itemStack, TAG);
    }

    public static boolean isBuyableSlot(ItemStack itemStack, int n) {
        return InventoryLocker.getBuyableSlotForLine(n).equals((Object)itemStack);
    }

    public static void lockSlots(@NotNull Player player) {
        InventoryLocker.lockSlots(player, false);
    }

    public static void lockSlots(@NotNull Player player, boolean bl) {
        if (!bl && player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (InventoryLocker.isEnabled()) {
            int n = InventoryLocker.getSlots((OfflinePlayer)player) + 8;
            for (int i = 35; i > n; --i) {
                player.getInventory().setItem(i, LOCKED_SLOT);
            }
            if (n < 35) {
                player.getInventory().setItem(n + 1, InventoryLocker.getBuyableSlotForLine(InventoryLocker.getLine(n + 1)));
            }
        }
        InventoryManager.lockQuickSlots(player);
        InventoryManager.lockEmptySlots(player);
    }

    public static void unlockSlots(@NotNull Player player) {
        if (InventoryLocker.isEnabled()) {
            for (int i = 8 + InventoryLocker.getSlots((OfflinePlayer)player); i < 36; ++i) {
                ItemStack itemStack = player.getInventory().getItem(i);
                if (!InventoryLocker.isLockedSlot(itemStack)) continue;
                player.getInventory().setItem(i, null);
            }
        }
        InventoryManager.unlockQuickSlots(player);
        InventoryManager.unlockEmptySlots(player);
    }

    public static boolean canBuySlot(@NotNull Player player, int n) {
        int n2;
        double d;
        FileConfiguration fileConfiguration = Config.getConfig();
        if (fileConfiguration.getBoolean("slots.money.enabled") && !PlayerUtils.checkMoney(player, d = fileConfiguration.getDouble("slots.money.cost.line" + n))) {
            return false;
        }
        if (fileConfiguration.getBoolean("slots.level.enabled") && !PlayerUtils.checkLevel(player, n2 = fileConfiguration.getInt("slots.level.required.line" + n))) {
            PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("error.level", n2));
            return false;
        }
        return true;
    }

    private static int getSlots(OfflinePlayer offlinePlayer) {
        int n = Config.getConfig().getInt("slots.free") + InventoryManager.get(offlinePlayer).getBuyedGenericSlots();
        return Math.min(n, 27);
    }
}

