/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.inventory;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;

public enum ArmorType {
    HELMET,
    CHESTPLATE,
    LEGGINGS,
    BOOTS,
    UNKNOWN;


    @NotNull
    public static ArmorType matchType(ItemStack itemStack) {
        if (ItemUtils.isEmpty(itemStack)) {
            return UNKNOWN;
        }
        if (itemStack.getType() == Material.ELYTRA) {
            return CHESTPLATE;
        }
        String[] stringArray = itemStack.getType().name().split("_");
        String string = stringArray[stringArray.length - 1];
        try {
            return ArmorType.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return UNKNOWN;
        }
    }

    @Nullable
    public static Slot getArmorSlotById(int n) {
        switch (n) {
            case 5: {
                return SlotManager.instance().getSlot("helmet");
            }
            case 6: {
                return SlotManager.instance().getSlot("chestplate");
            }
            case 7: {
                return SlotManager.instance().getSlot("leggings");
            }
            case 8: {
                return SlotManager.instance().getSlot("boots");
            }
        }
        return null;
    }

    @Nullable
    public ItemStack getItem(@NotNull Player player) {
        EntityEquipment entityEquipment = player.getEquipment();
        if (entityEquipment == null) {
            return null;
        }
        switch (this) {
            case HELMET: {
                return entityEquipment.getHelmet();
            }
            case CHESTPLATE: {
                return entityEquipment.getChestplate();
            }
            case LEGGINGS: {
                return entityEquipment.getLeggings();
            }
            case BOOTS: {
                return entityEquipment.getBoots();
            }
        }
        return null;
    }

    public int getSlot() {
        Slot slot = null;
        switch (this) {
            case HELMET: {
                slot = SlotManager.instance().getSlot("helmet");
                break;
            }
            case CHESTPLATE: {
                slot = SlotManager.instance().getSlot("chestplate");
                break;
            }
            case LEGGINGS: {
                slot = SlotManager.instance().getSlot("leggings");
                break;
            }
            case BOOTS: {
                slot = SlotManager.instance().getSlot("boots");
            }
        }
        return slot == null ? -1 : slot.getSlotId();
    }
}

