/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.event.listener;

import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.InventorySaver;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class PlayerListener
implements Listener {
    @EventHandler
    public void onCommand(@NotNull PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        Player player = playerCommandPreprocessEvent.getPlayer();
        if (InventoryManager.isAllowedWorld(player.getWorld()) && !InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("error.rp.denied"));
            playerCommandPreprocessEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerDead(@NotNull PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        if (InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            InventorySaver.save(player, playerDeathEvent.getDrops(), RPGInventory.getPermissions().has(player, "rpginventory.keep.items") || playerDeathEvent.getKeepInventory(), RPGInventory.getPermissions().has(player, "rpginventory.keep.armor") || playerDeathEvent.getKeepInventory(), RPGInventory.getPermissions().has(player, "rpginventory.keep.rpginv") || playerDeathEvent.getKeepInventory());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerRespawn(@NotNull PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        if (InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            InventorySaver.restore(player);
        }
    }
}

