/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.event.listener;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.compat.SoundCompat;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.PlayerWrapper;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.item.ItemManager;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.pet.PetFood;
import ru.endlesscode.rpginventory.pet.PetManager;
import ru.endlesscode.rpginventory.pet.PetType;
import ru.endlesscode.rpginventory.utils.EntityUtils;
import ru.endlesscode.rpginventory.utils.LocationUtils;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.scheduler.TrackedBukkitRunnable;

public class PetListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (!(playerInteractEntityEvent.getRightClicked() instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)playerInteractEntityEvent.getRightClicked();
        UUID uUID = PetManager.getPetOwner(livingEntity);
        if (uUID == null) {
            return;
        }
        if (!playerInteractEntityEvent.getPlayer().getUniqueId().equals(uUID)) {
            playerInteractEntityEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemUse(@NotNull PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (!playerInteractEvent.hasItem() || !InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        Inventory inventory = InventoryManager.get((OfflinePlayer)player).getInventory();
        ItemStack itemStack = playerInteractEvent.getItem();
        if (player.getGameMode() == GameMode.CREATIVE && PetManager.isPetItem(itemStack)) {
            itemStack = PetManager.toPetItem(itemStack);
            player.getEquipment().setItemInMainHand(itemStack);
        }
        if (PetType.isPetItem(itemStack) && (playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK || playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR)) {
            Slot slot = SlotManager.instance().getPetSlot();
            if (slot != null && slot.isCup(inventory.getItem(PetManager.getPetSlotId())) && ItemManager.allowedForPlayer(player, itemStack, false)) {
                inventory.setItem(PetManager.getPetSlotId(), playerInteractEvent.getItem());
                PetManager.respawnPet(player, itemStack);
                player.getEquipment().setItemInMainHand(null);
            }
            playerInteractEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDeath(@NotNull PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || !PetManager.isEnabled()) {
            return;
        }
        PetManager.despawnPet((OfflinePlayer)player);
    }

    @EventHandler
    public void onPlayerRespawn(@NotNull PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || !PetManager.isEnabled()) {
            return;
        }
        PetManager.respawnPet((OfflinePlayer)player);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPlayerTeleport(@NotNull PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || !PetManager.isEnabled()) {
            return;
        }
        if (!InventoryManager.get((OfflinePlayer)player).hasPet()) {
            return;
        }
        Location location = playerTeleportEvent.getFrom();
        Location location2 = playerTeleportEvent.getTo();
        if (!location.getWorld().getName().equals(location2.getWorld().getName())) {
            PetManager.respawnPet((OfflinePlayer)player);
            return;
        }
        if (location.getBlockX() != location2.getBlockX() || location.getBlockZ() != location2.getBlockZ() || location.distance(location2) < 0.775) {
            return;
        }
        double d = (double)playerTeleportEvent.getPlayer().getServer().getViewDistance() / 2.0 * 15.75;
        ItemStack itemStack = InventoryManager.get((OfflinePlayer)player).getInventory().getItem(PetManager.getPetSlotId());
        if (location.distance(location2) > d && itemStack != null) {
            PetManager.respawnPet((OfflinePlayer)player);
        } else if (LocationUtils.isSafeLocation(player.getLocation())) {
            PetManager.teleportPet(player, location2);
        }
    }

    @EventHandler
    public void onPetFeed(@NotNull PlayerInteractEntityEvent playerInteractEntityEvent) {
        Player player = playerInteractEntityEvent.getPlayer();
        ItemStack itemStack = player.getEquipment().getItemInMainHand();
        if (playerInteractEntityEvent.getRightClicked() == null || !InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        PlayerWrapper playerWrapper = InventoryManager.get((OfflinePlayer)player);
        if (PetFood.isFoodItem(itemStack) && playerWrapper.hasPet() && playerInteractEntityEvent.getRightClicked() == playerWrapper.getPet()) {
            playerInteractEntityEvent.setCancelled(true);
            LivingEntity livingEntity = (LivingEntity)playerInteractEntityEvent.getRightClicked();
            PetFood petFood = PetManager.getFoodFromItem(itemStack);
            if (livingEntity.getHealth() == this.getMaxHealth(livingEntity) || petFood == null || !petFood.canBeEaten(playerWrapper.getPet())) {
                return;
            }
            double d = livingEntity.getHealth() + petFood.getValue();
            livingEntity.setHealth(Math.min(d, this.getMaxHealth(livingEntity)));
            itemStack.setAmount(itemStack.getAmount() - 1);
            player.getEquipment().setItemInMainHand(itemStack);
            livingEntity.getWorld().playSound(livingEntity.getLocation(), SoundCompat.EAT.get(), 1.0f, (float)(1.0 + Math.random() * 0.4));
        }
    }

    private double getMaxHealth(LivingEntity livingEntity) {
        AttributeInstance attributeInstance = livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        Objects.requireNonNull(attributeInstance);
        return attributeInstance.getValue();
    }

    @EventHandler
    public void onPetDeath(@NotNull EntityDeathEvent entityDeathEvent) {
        if (entityDeathEvent.getEntity() == null || PetManager.getPetOwner(entityDeathEvent.getEntity()) == null) {
            return;
        }
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        Player player = Bukkit.getPlayer((UUID)PetManager.getPetOwner(livingEntity));
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        PlayerWrapper playerWrapper = InventoryManager.get((OfflinePlayer)player);
        if (livingEntity == playerWrapper.getPet()) {
            Inventory inventory = playerWrapper.getInventory();
            ItemStack itemStack = inventory.getItem(PetManager.getPetSlotId());
            PetType petType = PetManager.getPetFromItem(itemStack);
            if (petType != null && petType.isRevival()) {
                PetManager.saveDeathTime(itemStack);
                PetManager.saveHealth(itemStack, 0.0);
                inventory.setItem(PetManager.getPetSlotId(), itemStack);
                PetManager.startCooldownTimer(player.getPlayer(), itemStack);
            } else {
                inventory.setItem(PetManager.getPetSlotId(), null);
            }
            entityDeathEvent.getDrops().clear();
            playerWrapper.setPet(null);
        }
    }

    @EventHandler
    public void onTarget(@NotNull EntityTargetLivingEntityEvent entityTargetLivingEntityEvent) {
        if (!(entityTargetLivingEntityEvent.getEntity() != null && entityTargetLivingEntityEvent.getEntity() instanceof Tameable && entityTargetLivingEntityEvent.getEntity() instanceof LivingEntity && entityTargetLivingEntityEvent.getTarget() != null && InventoryManager.isAllowedWorld(entityTargetLivingEntityEvent.getTarget().getWorld()))) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entityTargetLivingEntityEvent.getEntity();
        OfflinePlayer offlinePlayer = (OfflinePlayer)((Tameable)livingEntity).getOwner();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)offlinePlayer)) {
            return;
        }
        PlayerWrapper playerWrapper = InventoryManager.get(offlinePlayer);
        if (playerWrapper.hasPet() && livingEntity == playerWrapper.getPet()) {
            PetType petType = PetManager.getPetFromEntity(livingEntity, offlinePlayer);
            if (petType == null) {
                return;
            }
            if (entityTargetLivingEntityEvent.getTarget() != null && entityTargetLivingEntityEvent.getTarget().getType() == EntityType.PLAYER) {
                entityTargetLivingEntityEvent.setCancelled(!petType.isAttackPlayers());
            } else {
                entityTargetLivingEntityEvent.setCancelled(!petType.isAttackMobs());
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onAttack(@NotNull EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Location location;
        LivingEntity livingEntity;
        Object object;
        if (entityDamageByEntityEvent.getEntity() == null || entityDamageByEntityEvent.getDamager() == null || !InventoryManager.isAllowedWorld(entityDamageByEntityEvent.getEntity().getWorld())) {
            return;
        }
        Player player = null;
        if (entityDamageByEntityEvent.getDamager().getType() == EntityType.PLAYER) {
            player = (Player)entityDamageByEntityEvent.getDamager();
        } else if (entityDamageByEntityEvent.getDamager() instanceof Projectile && (object = (Projectile)entityDamageByEntityEvent.getDamager()).getShooter() instanceof Player) {
            player = (Player)object.getShooter();
        }
        if (player != null && !InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        if (entityDamageByEntityEvent.getDamager() instanceof LivingEntity && entityDamageByEntityEvent.getDamager() instanceof Tameable) {
            OfflinePlayer offlinePlayer;
            PetType petType;
            object = (Tameable)entityDamageByEntityEvent.getDamager();
            AnimalTamer animalTamer = object.getOwner();
            if (animalTamer != null && (petType = PetManager.getPetFromEntity((LivingEntity)object, offlinePlayer = (OfflinePlayer)animalTamer)) != null) {
                if (offlinePlayer.isOnline()) {
                    entityDamageByEntityEvent.setDamage(petType.getDamage());
                } else {
                    PetManager.despawnPet((Tameable)object);
                }
            }
        } else if (entityDamageByEntityEvent.getEntity() instanceof LivingEntity && entityDamageByEntityEvent.getEntity() instanceof Tameable && !Config.getConfig().getBoolean("attack.own-pet") && player != null) {
            object = (Tameable)entityDamageByEntityEvent.getEntity();
            AnimalTamer animalTamer = object.getOwner();
            if (animalTamer != null && player.getUniqueId().equals(animalTamer.getUniqueId())) {
                entityDamageByEntityEvent.setCancelled(true);
            }
        } else if (player != null && (livingEntity = ((PlayerWrapper)(object = InventoryManager.get((OfflinePlayer)player))).getPet()) != null && livingEntity.getType() == EntityType.WOLF && player != ((Wolf)livingEntity).getTarget() && (location = player.getLocation()).distance(livingEntity.getLocation()) > 20.0) {
            PetManager.respawnPet((OfflinePlayer)player);
        }
    }

    @EventHandler
    public void onMountPet(@NotNull VehicleEnterEvent vehicleEnterEvent) {
        if (vehicleEnterEvent.getEntered().getType() != EntityType.PLAYER || vehicleEnterEvent.getVehicle().getType() != EntityType.HORSE) {
            return;
        }
        Player player = (Player)vehicleEnterEvent.getEntered();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        Horse horse = (Horse)vehicleEnterEvent.getVehicle();
        if (PetManager.getPetFromEntity((LivingEntity)horse, (OfflinePlayer)player) != null && player != horse.getOwner()) {
            PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("error.mount.owner", horse.getOwner().getName()));
            vehicleEnterEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldChanged(@NotNull EntityPortalEnterEvent entityPortalEnterEvent) {
        if (entityPortalEnterEvent.getEntity() == null || !(entityPortalEnterEvent.getEntity() instanceof Tameable) || !(entityPortalEnterEvent.getEntity() instanceof LivingEntity)) {
            return;
        }
        OfflinePlayer offlinePlayer = (OfflinePlayer)((Tameable)entityPortalEnterEvent.getEntity()).getOwner();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)offlinePlayer)) {
            return;
        }
        PlayerWrapper playerWrapper = InventoryManager.get(offlinePlayer);
        if (entityPortalEnterEvent.getEntity() == playerWrapper.getPet()) {
            PetManager.respawnPet(offlinePlayer);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPetInventoryOpened(@NotNull InventoryOpenEvent inventoryOpenEvent) {
        Player player = (Player)inventoryOpenEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        PlayerWrapper playerWrapper = InventoryManager.get((OfflinePlayer)player);
        final LivingEntity livingEntity = InventoryManager.get((OfflinePlayer)player).getPet();
        if (livingEntity != null && inventoryOpenEvent.getInventory().getHolder() == livingEntity) {
            playerWrapper.openInventory();
            inventoryOpenEvent.setCancelled(true);
            new TrackedBukkitRunnable(){

                public void run() {
                    HorseInventory horseInventory = ((Horse)livingEntity).getInventory();
                    horseInventory.setSaddle(new ItemStack(Material.SADDLE));
                }
            }.runTaskLater((Plugin)RPGInventory.getInstance(), 1L);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerMove(@NotNull PlayerMoveEvent playerMoveEvent) {
        PetType petType;
        Player player = playerMoveEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        LivingEntity livingEntity = InventoryManager.get((OfflinePlayer)player).getPet();
        if (livingEntity != null && !livingEntity.getPassengers().isEmpty() && livingEntity.getPassengers().get(0) != player && (petType = PetManager.getPetFromEntity(livingEntity, (OfflinePlayer)player)) != null && petType.getRole() != PetType.Role.COMPANION) {
            EntityUtils.goPetToPlayer(player, livingEntity);
        }
    }
}

