/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.event.listener;

import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.inventory.ItemStack;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.inventory.InventoryLocker;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class LockerListener
implements Listener {
    @EventHandler
    public void onGameModeSwitch(@NotNull PlayerGameModeChangeEvent playerGameModeChangeEvent) {
        Player player = playerGameModeChangeEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        if (playerGameModeChangeEvent.getNewGameMode() == GameMode.CREATIVE) {
            InventoryLocker.unlockSlots(player);
        } else if (playerGameModeChangeEvent.getPlayer().getGameMode() == GameMode.CREATIVE) {
            InventoryLocker.lockSlots(player, true);
        }
    }

    @EventHandler
    public void onInventoryClick(@NotNull InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        if (ItemUtils.isNotEmpty(itemStack) && InventoryLocker.isLockedSlot(itemStack)) {
            int n = inventoryClickEvent.getSlot();
            int n2 = InventoryLocker.getLine(n);
            if (InventoryLocker.isBuyableSlot(itemStack, n2)) {
                if (InventoryLocker.canBuySlot((Player)inventoryClickEvent.getWhoClicked(), n2) && InventoryLocker.buySlot(player, n2)) {
                    player.getInventory().setItem(n, null);
                    inventoryClickEvent.setCurrentItem(null);
                    if (n < 35) {
                        player.getInventory().setItem(n + 1, InventoryLocker.getBuyableSlotForLine(InventoryLocker.getLine(n + 1)));
                    }
                    InventoryManager.get((OfflinePlayer)player).setBuyedSlots(InventoryManager.get((OfflinePlayer)player).getBuyedGenericSlots() + 1);
                } else {
                    inventoryClickEvent.setCancelled(true);
                }
            } else {
                PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("error.previous"));
                inventoryClickEvent.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDeath(@NotNull PlayerDeathEvent playerDeathEvent) {
        if (!InventoryManager.playerIsLoaded((AnimalTamer)playerDeathEvent.getEntity())) {
            return;
        }
        List list = playerDeathEvent.getDrops();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemStack = (ItemStack)list.get(i);
            if (itemStack == null || !InventoryLocker.isLockedSlot(itemStack) && !InventoryManager.isEmptySlot(itemStack)) continue;
            playerDeathEvent.getDrops().set(i, new ItemStack(Material.AIR));
        }
    }
}

