/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.event.listener;

import java.util.Iterator;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.compat.SoundCompat;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.item.CustomItem;
import ru.endlesscode.rpginventory.item.ItemManager;
import ru.endlesscode.rpginventory.item.ItemStat;
import ru.endlesscode.rpginventory.item.Modifier;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.utils.EffectUtils;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.scheduler.TrackedBukkitRunnable;

public class ItemListener
implements Listener {
    @EventHandler(priority=EventPriority.LOW)
    public void onDamage(@NotNull EntityDamageByEntityEvent entityDamageByEntityEvent) {
        List<Slot> list;
        ItemStack itemStack;
        Player player;
        Modifier modifier;
        try {
            if (entityDamageByEntityEvent.getEntityType() == EntityType.PLAYER) {
                modifier = ItemManager.getModifier((Player)entityDamageByEntityEvent.getEntity(), ItemStat.StatType.ARMOR);
                double d = entityDamageByEntityEvent.getDamage(EntityDamageEvent.DamageModifier.ARMOR);
                double d2 = (d - modifier.getBonus()) * modifier.getMultiplier();
                if (d2 > 0.0) {
                    d2 = 0.0;
                }
                entityDamageByEntityEvent.setDamage(EntityDamageEvent.DamageModifier.ARMOR, d2);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (entityDamageByEntityEvent.getDamager().getType() == EntityType.PLAYER) {
            itemStack = (player = (Player)entityDamageByEntityEvent.getDamager()).getEquipment().getItemInMainHand();
            modifier = ItemManager.getModifier(player, ItemUtils.isEmpty(itemStack) ? ItemStat.StatType.HAND_DAMAGE : ItemStat.StatType.DAMAGE);
        } else if (entityDamageByEntityEvent.getDamager().getType() == EntityType.ARROW && ((Arrow)entityDamageByEntityEvent.getDamager()).getShooter() instanceof Player) {
            player = (Player)((Arrow)entityDamageByEntityEvent.getDamager()).getShooter();
            itemStack = player.getEquipment().getItemInMainHand();
            modifier = ItemManager.getModifier(player, ItemStat.StatType.BOW_DAMAGE);
        } else {
            return;
        }
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        if (!ItemManager.allowedForPlayer(player, itemStack, true)) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
        boolean bl = Config.getConfig().getBoolean("attack.force-weapon");
        boolean bl2 = Config.getConfig().getBoolean("attack.require-weapon");
        PlayerInventory playerInventory = player.getInventory();
        if ((bl || bl2) && SlotManager.instance().getSlot(playerInventory.getHeldItemSlot(), InventoryType.SlotType.QUICKBAR) == null && (list = SlotManager.instance().getActiveSlots()).size() != 0) {
            if (bl) {
                for (Slot slot : list) {
                    if (InventoryManager.isQuickEmptySlot(playerInventory.getItem(slot.getQuickSlot()))) continue;
                    playerInventory.setHeldItemSlot(slot.getQuickSlot());
                    break;
                }
            }
            if (bl2) {
                entityDamageByEntityEvent.setCancelled(true);
                return;
            }
        }
        double d = entityDamageByEntityEvent.getDamage(EntityDamageEvent.DamageModifier.BASE);
        double d3 = (CustomItem.isCustomItem(itemStack) ? 1.0 : d) + modifier.getBonus() * modifier.getMultiplier();
        double d4 = ItemManager.getModifier(player, ItemStat.StatType.CRIT_CHANCE).getMultiplier() - 1.0;
        if (Math.random() <= d4) {
            d3 *= ItemManager.getModifier(player, ItemStat.StatType.CRIT_DAMAGE).getMultiplier();
            player.getWorld().playSound(entityDamageByEntityEvent.getEntity().getLocation(), SoundCompat.SUCCESSFUL_HIT.get(), 1.0f, (float)(0.5 + Math.random() * 0.4));
            EffectUtils.playParticlesToAll(Particle.CRIT, 10, entityDamageByEntityEvent.getEntity().getLocation());
        }
        entityDamageByEntityEvent.setDamage(EntityDamageEvent.DamageModifier.BASE, d3);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJump(@NotNull PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        Vector vector = player.getVelocity();
        Modifier modifier = ItemManager.getModifier(player, ItemStat.StatType.JUMP);
        if (modifier.getBonus() == 0.0 && modifier.getMultiplier() == 1.0) {
            return;
        }
        if (playerMoveEvent.getTo() != null && vector.getY() == (double)0.42f) {
            double d = (1.5 + Math.sqrt(modifier.getBonus())) * modifier.getMultiplier();
            Vector vector2 = playerMoveEvent.getTo().toVector().subtract(playerMoveEvent.getFrom().toVector());
            vector.setX(vector2.getX() * d * (double)player.getWalkSpeed());
            vector.setY(vector.getY() * d / 1.5);
            vector.setZ(vector2.getZ() * d * (double)player.getWalkSpeed());
            player.setVelocity(vector);
        }
    }

    @EventHandler
    public void onPlayerFall(@NotNull EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getEntity().getType() != EntityType.PLAYER || entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        Modifier modifier = ItemManager.getModifier(player, ItemStat.StatType.JUMP);
        double d = (1.5 + modifier.getBonus()) * modifier.getMultiplier() * 1.5;
        entityDamageEvent.setDamage(entityDamageEvent.getDamage() - d);
        if (entityDamageEvent.getDamage() <= 0.0) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onItemUse(@NotNull PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || !playerInteractEvent.hasItem()) {
            return;
        }
        if (!ItemManager.allowedForPlayer(player, playerInteractEvent.getItem(), true)) {
            playerInteractEvent.setCancelled(true);
            PlayerUtils.updateInventory(player);
            return;
        }
        if (CustomItem.isCustomItem(playerInteractEvent.getItem())) {
            CustomItem customItem = ItemManager.getCustomItem(playerInteractEvent.getItem());
            if (customItem == null) {
                return;
            }
            if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR || playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
                customItem.onRightClick(player);
            } else {
                customItem.onLeftClick(player);
            }
            if (playerInteractEvent.getItem().getType() != Material.BOW) {
                playerInteractEvent.setCancelled(true);
            }
        }
        ItemManager.updateStats(player);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void afterPlayerRespawn(@NotNull PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        ItemManager.updateStats(playerRespawnEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void afterEquipChange(@NotNull InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        if (CustomItem.isCustomItem(inventoryClickEvent.getCursor()) || CustomItem.isCustomItem(inventoryClickEvent.getCurrentItem())) {
            ItemManager.updateStats(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void afterEquipChange(final @NotNull InventoryDragEvent inventoryDragEvent) {
        Player player = (Player)inventoryDragEvent.getWhoClicked();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        new TrackedBukkitRunnable(){

            public void run() {
                InventoryView inventoryView = inventoryDragEvent.getView();
                Iterator iterator2 = inventoryDragEvent.getRawSlots().iterator();
                while (iterator2.hasNext()) {
                    int n = (Integer)iterator2.next();
                    ItemStack itemStack = inventoryView.getItem(n);
                    if (!CustomItem.isCustomItem(itemStack)) continue;
                    ItemManager.updateStats((Player)inventoryDragEvent.getWhoClicked());
                }
            }
        }.runTaskLater((Plugin)RPGInventory.getInstance(), 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void afterItemHeld(final @NotNull PlayerItemHeldEvent playerItemHeldEvent) {
        Player player = playerItemHeldEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        final ItemStack itemStack = player.getInventory().getItem(playerItemHeldEvent.getNewSlot());
        final ItemStack itemStack2 = player.getInventory().getItem(playerItemHeldEvent.getPreviousSlot());
        new TrackedBukkitRunnable(){

            public void run() {
                if (CustomItem.isCustomItem(itemStack2) || CustomItem.isCustomItem(itemStack)) {
                    ItemManager.updateStats(playerItemHeldEvent.getPlayer());
                }
            }
        }.runTaskLater((Plugin)RPGInventory.getInstance(), 2L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void afterPickupItem(@NotNull EntityPickupItemEvent entityPickupItemEvent) {
        if (entityPickupItemEvent.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)entityPickupItemEvent.getEntity();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        ItemStack itemStack = entityPickupItemEvent.getItem().getItemStack();
        if (CustomItem.isCustomItem(itemStack)) {
            ItemManager.updateStats(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void afterDropItem(@NotNull PlayerDropItemEvent playerDropItemEvent) {
        Player player = playerDropItemEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        if (CustomItem.isCustomItem(playerDropItemEvent.getItemDrop().getItemStack())) {
            ItemManager.updateStats(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void afterBreakItem(@NotNull PlayerItemBreakEvent playerItemBreakEvent) {
        Player player = playerItemBreakEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        if (CustomItem.isCustomItem(playerItemBreakEvent.getBrokenItem())) {
            ItemManager.updateStats(player);
        }
    }
}

