/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.event.listener;

import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.api.InventoryAPI;
import ru.endlesscode.rpginventory.compat.SoundCompat;
import ru.endlesscode.rpginventory.event.PlayerInventoryLoadEvent;
import ru.endlesscode.rpginventory.inventory.ActionType;
import ru.endlesscode.rpginventory.inventory.InventoryLocker;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.PlayerWrapper;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackManager;
import ru.endlesscode.rpginventory.inventory.slot.ActionSlot;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.item.ItemManager;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.misc.config.VanillaSlotAction;
import ru.endlesscode.rpginventory.pet.PetManager;
import ru.endlesscode.rpginventory.pet.mypet.MyPetManager;
import ru.endlesscode.rpginventory.utils.InventoryUtils;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.scheduler.TrackedBukkitRunnable;

public class InventoryListener
implements Listener {
    private static final int QUICKBAR_SIZE = 9;

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(@NotNull PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (InventoryManager.isAllowedWorld(player.getWorld())) {
            InventoryManager.initPlayer(player, false);
        }
    }

    @EventHandler
    public void onPlayerQuit(@NotNull PlayerQuitEvent playerQuitEvent) {
        InventoryManager.unloadPlayerInventory(playerQuitEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLoadInventory(@NotNull PlayerInventoryLoadEvent.Post post) {
        Player player = post.getPlayer();
        ItemManager.updateStats(player);
        PlayerInventory playerInventory = player.getInventory();
        playerInventory.setArmorContents(ItemUtils.syncItems(playerInventory.getArmorContents()));
        playerInventory.setContents(ItemUtils.syncItems(playerInventory.getContents()));
        Inventory inventory = InventoryManager.get((OfflinePlayer)player).getInventory();
        inventory.setContents(ItemUtils.syncItems(inventory.getContents()));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void prePlayerRespawn(@NotNull PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getPlayer();
        if (InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            InventoryLocker.lockSlots(player);
        }
    }

    @EventHandler
    public void onQuickSlotHeld(@NotNull PlayerItemHeldEvent playerItemHeldEvent) {
        Player player = playerItemHeldEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        int n = playerItemHeldEvent.getNewSlot();
        Slot slot = InventoryManager.getQuickSlot(n);
        if (slot != null && slot.isCup(player.getInventory().getItem(n))) {
            playerItemHeldEvent.setCancelled(true);
            InventoryUtils.heldFreeSlot(player, n, (playerItemHeldEvent.getPreviousSlot() + 1) % 9 == n ? InventoryUtils.SearchType.NEXT : InventoryUtils.SearchType.PREV);
        }
    }

    @EventHandler
    public void onBreakItem(@NotNull PlayerItemBreakEvent playerItemBreakEvent) {
        this.onItemDisappeared((PlayerEvent)playerItemBreakEvent, playerItemBreakEvent.getBrokenItem());
    }

    @EventHandler
    public void onDropQuickSlot(@NotNull PlayerDropItemEvent playerDropItemEvent) {
        this.onItemDisappeared((PlayerEvent)playerDropItemEvent, playerDropItemEvent.getItemDrop().getItemStack());
    }

    private void onItemDisappeared(PlayerEvent playerEvent, @NotNull ItemStack itemStack) {
        Slot slot;
        final Player player = playerEvent.getPlayer();
        final PlayerInventory playerInventory = player.getInventory();
        final int n = playerInventory.getHeldItemSlot();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        if ((ItemUtils.isEmpty(playerInventory.getItemInMainHand()) || itemStack.equals((Object)playerInventory.getItemInMainHand())) && (slot = InventoryManager.getQuickSlot(n)) != null) {
            new TrackedBukkitRunnable(){

                public void run() {
                    InventoryUtils.heldFreeSlot(player, n, InventoryUtils.SearchType.NEXT);
                    playerInventory.setItem(n, slot.getCup());
                }
            }.runTaskLater((Plugin)RPGInventory.getInstance(), 1L);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPickupToQuickSlot(@NotNull EntityPickupItemEvent entityPickupItemEvent) {
        if (entityPickupItemEvent.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)entityPickupItemEvent.getEntity();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || !ItemManager.allowedForPlayer(player, entityPickupItemEvent.getItem().getItemStack(), false)) {
            return;
        }
        for (Slot slot : SlotManager.instance().getQuickSlots()) {
            int n = slot.getQuickSlot();
            if (!slot.isCup(player.getInventory().getItem(n)) || !slot.isValidItem(entityPickupItemEvent.getItem().getItemStack())) continue;
            player.getInventory().setItem(n, entityPickupItemEvent.getItem().getItemStack());
            entityPickupItemEvent.getItem().remove();
            player.playSound(player.getLocation(), SoundCompat.ITEM_PICKUP.get(), 0.3f, 1.7f);
            if (Config.getConfig().getBoolean("attack.auto-held")) {
                player.getInventory().setHeldItemSlot(slot.getQuickSlot());
            }
            entityPickupItemEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryDrag(@NotNull InventoryDragEvent inventoryDragEvent) {
        Player player = (Player)inventoryDragEvent.getWhoClicked();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        for (Integer n : inventoryDragEvent.getRawSlots()) {
            ItemStack itemStack = inventoryDragEvent.getOldCursor();
            Inventory inventory = inventoryDragEvent.getInventory();
            if (PetManager.isPetItem(itemStack)) {
                inventoryDragEvent.setCancelled(true);
                return;
            }
            if (inventory.getType() == InventoryType.CRAFTING) {
                boolean bl;
                if (InventoryManager.get((OfflinePlayer)player).isOpened()) {
                    return;
                }
                boolean bl2 = bl = n >= 1 && n <= 4;
                if (n != 45 && (!bl || Config.craftSlotsAction != VanillaSlotAction.RPGINV)) continue;
                inventoryDragEvent.setCancelled(true);
                return;
            }
            if (!InventoryAPI.isRPGInventory(inventory) || n >= 54) continue;
            inventoryDragEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onInventoryClick(@NotNull InventoryClickEvent inventoryClickEvent) {
        boolean bl;
        boolean bl2;
        Object object;
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        InventoryType.SlotType slotType = inventoryClickEvent.getSlotType();
        if (slotType == InventoryType.SlotType.OUTSIDE) {
            return;
        }
        InventoryAction inventoryAction = inventoryClickEvent.getAction();
        if ((inventoryAction == InventoryAction.HOTBAR_SWAP || inventoryAction == InventoryAction.HOTBAR_MOVE_AND_READD) && SlotManager.instance().getSlot(inventoryClickEvent.getHotbarButton(), InventoryType.SlotType.QUICKBAR) != null) {
            inventoryClickEvent.setCancelled(true);
            return;
        }
        final Inventory inventory = inventoryClickEvent.getInventory();
        final int n = inventoryClickEvent.getRawSlot();
        if (inventory.getType() == InventoryType.CRAFTING) {
            object = InventoryManager.get((OfflinePlayer)player);
            if (((PlayerWrapper)object).isOpened()) {
                return;
            }
            bl2 = false;
            switch (slotType) {
                case CRAFTING: 
                case RESULT: {
                    bl2 = Config.craftSlotsAction == VanillaSlotAction.RPGINV;
                    break;
                }
                case QUICKBAR: {
                    bl2 = n == 45 && Config.armorSlotsAction == VanillaSlotAction.RPGINV;
                    break;
                }
                case ARMOR: {
                    boolean bl3 = bl2 = Config.armorSlotsAction == VanillaSlotAction.RPGINV;
                }
            }
            if (bl2) {
                ((PlayerWrapper)object).openInventoryDeferred(true);
                inventoryClickEvent.setCancelled(true);
                return;
            }
        }
        object = SlotManager.instance().getSlot(inventoryClickEvent.getSlot(), slotType);
        bl2 = InventoryAPI.isRPGInventory(inventory);
        boolean bl4 = bl = slotType == InventoryType.SlotType.QUICKBAR && object != null && (((Slot)object).isQuick() || ((Slot)object).getSlotType() == Slot.SlotType.SHIELD);
        if ((bl2 || bl) && player.getGameMode() != GameMode.CREATIVE) {
            boolean bl5;
            boolean bl6 = bl5 = n < inventory.getSize();
            if (bl5 && object == null || inventoryAction == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                inventoryClickEvent.setCancelled(true);
                return;
            }
            if (object == null || !bl && !bl5) {
                return;
            }
            PlayerWrapper playerWrapper = null;
            if (bl2 && (playerWrapper = (PlayerWrapper)inventory.getHolder()) != null && playerWrapper.isFlying()) {
                PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("error.fall"));
                inventoryClickEvent.setCancelled(true);
                return;
            }
            ItemStack itemStack = inventoryClickEvent.getCurrentItem();
            ActionType actionType = ActionType.getTypeOfAction(inventoryAction);
            if (!this.validateClick(player, playerWrapper, (Slot)object, actionType, itemStack, slotType) || ((Slot)object).getSlotType() == Slot.SlotType.INFO) {
                inventoryClickEvent.setCancelled(true);
                return;
            }
            if (((Slot)object).getSlotType() == Slot.SlotType.ACTION) {
                ((ActionSlot)object).preformAction(player);
                inventoryClickEvent.setCancelled(true);
                return;
            }
            ItemStack itemStack2 = inventoryClickEvent.getCursor();
            if (playerWrapper != null && ((Slot)object).getSlotType() == Slot.SlotType.ARMOR) {
                this.onArmorSlotClick(inventoryClickEvent, playerWrapper, (Slot)object, itemStack2, itemStack);
                return;
            }
            if (((Slot)object).getSlotType() == Slot.SlotType.ACTIVE || ((Slot)object).getSlotType() == Slot.SlotType.PASSIVE || ((Slot)object).getSlotType() == Slot.SlotType.SHIELD || ((Slot)object).getSlotType() == Slot.SlotType.ELYTRA) {
                inventoryClickEvent.setCancelled(!InventoryManager.validateUpdate(player, actionType, (Slot)object, itemStack2));
                if ((((Slot)object).getSlotType() == Slot.SlotType.SHIELD || ((Slot)object).getSlotType() == Slot.SlotType.ELYTRA) && actionType == ActionType.DROP) {
                    inventoryClickEvent.setCancelled(true);
                }
            } else if (((Slot)object).getSlotType() == Slot.SlotType.PET) {
                if (RPGInventory.isMyPetHooked()) {
                    inventoryClickEvent.setCancelled(!MyPetManager.validatePet(player, inventoryAction, itemStack, itemStack2));
                } else {
                    inventoryClickEvent.setCancelled(!InventoryManager.validatePet(player, inventoryAction, itemStack, itemStack2));
                }
            } else if (((Slot)object).getSlotType() == Slot.SlotType.BACKPACK) {
                if (inventoryClickEvent.getClick() == ClickType.RIGHT && BackpackManager.open(player, itemStack)) {
                    inventoryClickEvent.setCancelled(true);
                } else if (actionType != ActionType.GET) {
                    inventoryClickEvent.setCancelled(!BackpackManager.isBackpack(itemStack2));
                }
            }
            if (!inventoryClickEvent.isCancelled()) {
                TrackedBukkitRunnable trackedBukkitRunnable = new TrackedBukkitRunnable((Slot)object, player){
                    final /* synthetic */ Slot val$slot;
                    final /* synthetic */ Player val$player;
                    {
                        this.val$slot = slot;
                        this.val$player = player;
                    }

                    public void run() {
                        ItemStack itemStack = inventory.getItem(n);
                        if (itemStack == null || itemStack.getType() == Material.AIR) {
                            inventory.setItem(n, this.val$slot.getCup());
                            this.val$player.updateInventory();
                        }
                    }
                };
                if (((Slot)object).isQuick()) {
                    InventoryManager.updateQuickSlot(player, inventory, (Slot)object, inventoryClickEvent.getSlot(), slotType, inventoryAction, itemStack, itemStack2);
                    inventoryClickEvent.setCancelled(true);
                } else if (((Slot)object).getSlotType() == Slot.SlotType.SHIELD) {
                    InventoryManager.updateShieldSlot(player, inventory, (Slot)object, inventoryClickEvent.getSlot(), slotType, inventoryAction, itemStack, itemStack2);
                    inventoryClickEvent.setCancelled(true);
                    if (actionType == ActionType.GET || actionType == ActionType.DROP) {
                        trackedBukkitRunnable.runTaskLater((Plugin)RPGInventory.getInstance(), 1L);
                    }
                } else if (actionType == ActionType.GET || actionType == ActionType.DROP) {
                    trackedBukkitRunnable.runTaskLater((Plugin)RPGInventory.getInstance(), 1L);
                } else if (((Slot)object).isCup(itemStack)) {
                    inventoryClickEvent.setCurrentItem(null);
                }
            }
        }
    }

    private boolean validateClick(Player player, @Nullable PlayerWrapper playerWrapper, @NotNull Slot slot, ActionType actionType, ItemStack itemStack, InventoryType.SlotType slotType) {
        if (playerWrapper != null) {
            if (player != playerWrapper.getPlayer()) {
                return false;
            }
            if (!PlayerUtils.checkLevel(player, slot.getRequiredLevel())) {
                PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("error.level", slot.getRequiredLevel()));
                return false;
            }
            if (!(slot.isFree() || playerWrapper.isBuyedSlot(slot.getName()) || InventoryManager.buySlot(player, playerWrapper, slot))) {
                return false;
            }
        }
        return (actionType != ActionType.GET || slot.getSlotType() == Slot.SlotType.ACTION) && actionType != ActionType.DROP || !slot.isCup(itemStack) || slotType == InventoryType.SlotType.QUICKBAR;
    }

    private void onArmorSlotClick(InventoryClickEvent inventoryClickEvent, PlayerWrapper playerWrapper, final @NotNull Slot slot, @NotNull ItemStack itemStack, ItemStack itemStack2) {
        final Player player = playerWrapper.getPlayer().getPlayer();
        final Inventory inventory = inventoryClickEvent.getInventory();
        final int n = inventoryClickEvent.getRawSlot();
        InventoryAction inventoryAction = inventoryClickEvent.getAction();
        ActionType actionType = ActionType.getTypeOfAction(inventoryAction);
        if (InventoryManager.validateArmor(player, inventoryAction, slot, itemStack) && playerWrapper.getInventoryView() != null) {
            InventoryClickEvent inventoryClickEvent2 = new InventoryClickEvent(playerWrapper.getInventoryView(), InventoryType.SlotType.ARMOR, InventoryUtils.getArmorSlotId(slot), inventoryClickEvent.getClick(), inventoryAction);
            Bukkit.getPluginManager().callEvent((Event)inventoryClickEvent2);
            if (inventoryClickEvent2.isCancelled()) {
                inventoryClickEvent.setCancelled(true);
                return;
            }
            InventoryManager.updateArmor(player, inventory, slot, n, inventoryAction, itemStack2, itemStack);
            if (actionType == ActionType.GET) {
                inventory.setItem(n, slot.getCup());
            } else if (slot.isCup(itemStack2)) {
                player.setItemOnCursor(new ItemStack(Material.AIR));
            }
            player.updateInventory();
        }
        if (actionType == ActionType.DROP) {
            new TrackedBukkitRunnable(){

                public void run() {
                    inventory.setItem(n, slot.getCup());
                    player.updateInventory();
                }
            }.runTaskLater((Plugin)RPGInventory.getInstance(), 1L);
        } else {
            inventoryClickEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryOpen(@NotNull InventoryOpenEvent inventoryOpenEvent) {
        Inventory inventory = inventoryOpenEvent.getInventory();
        HumanEntity humanEntity = inventoryOpenEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)humanEntity)) {
            return;
        }
        if (InventoryAPI.isRPGInventory(inventory)) {
            PlayerWrapper playerWrapper = (PlayerWrapper)inventory.getHolder();
            InventoryManager.syncQuickSlots(playerWrapper);
            InventoryManager.syncInfoSlots(playerWrapper);
            InventoryManager.syncShieldSlot(playerWrapper);
            InventoryManager.syncArmor(playerWrapper);
        }
    }

    @EventHandler
    public void onInventoryClose(@NotNull InventoryCloseEvent inventoryCloseEvent) {
        if (InventoryAPI.isRPGInventory(inventoryCloseEvent.getInventory())) {
            PlayerWrapper playerWrapper = (PlayerWrapper)inventoryCloseEvent.getInventory().getHolder();
            if (playerWrapper == null || inventoryCloseEvent.getPlayer() != playerWrapper.getPlayer()) {
                return;
            }
            playerWrapper.onClose();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldChanged(@NotNull PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            if (InventoryManager.isAllowedWorld(player.getWorld())) {
                InventoryManager.initPlayer(player, InventoryManager.isAllowedWorld(playerChangedWorldEvent.getFrom()));
            }
            return;
        }
        if (!InventoryManager.isAllowedWorld(player.getWorld())) {
            InventoryManager.unloadPlayerInventory(player);
        } else if (InventoryManager.get((OfflinePlayer)player).hasPet()) {
            PetManager.respawnPet((OfflinePlayer)player);
        }
    }
}

