/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.event.listener;

import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import ru.endlesscode.rpginventory.compat.PlayerCompat;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.PlayerWrapper;
import ru.endlesscode.rpginventory.utils.LocationUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class ElytraListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onPlayerFall(@NotNull PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || player.isFlying() || player.getVehicle() != null) {
            return;
        }
        PlayerWrapper playerWrapper = InventoryManager.get((OfflinePlayer)player);
        boolean bl = false;
        if (!player.isOnGround()) {
            if (this.playerIsSneakOnLadder(player) || this.isPlayerCanFall(player)) {
                playerWrapper.onFall();
            } else if (!player.isGliding()) {
                bl = true;
            }
        } else if (playerWrapper.isFalling()) {
            bl = true;
        }
        if (bl) {
            playerWrapper.setFalling(false);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityToggleGlide(@NotNull EntityToggleGlideEvent entityToggleGlideEvent) {
        if (entityToggleGlideEvent.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)entityToggleGlideEvent.getEntity();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        if (entityToggleGlideEvent.isGliding()) {
            PlayerWrapper playerWrapper = InventoryManager.get((OfflinePlayer)player);
            playerWrapper.onStartGliding();
        }
    }

    private boolean isPlayerCanFall(@NotNull Player player) {
        double d = PlayerCompat.getWidth(player);
        return !LocationUtils.isUnderAnyBlockHonestly(player.getLocation(), d, 3) && !this.playerIsOnLadder(player);
    }

    private boolean playerIsSneakOnLadder(Player player) {
        return player.isSneaking() && this.playerIsOnLadder(player);
    }

    private boolean playerIsOnLadder(Player player) {
        return player.getLocation().getBlock().getType() == Material.LADDER;
    }
}

