/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.event.listener;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.craft.CraftExtension;
import ru.endlesscode.rpginventory.inventory.craft.CraftManager;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.packetwrapper.WrapperPlayServerWindowItems;

public class CraftListener
extends PacketAdapter
implements Listener {
    public CraftListener(@NotNull Plugin plugin) {
        super(plugin, new PacketType[]{WrapperPlayServerWindowItems.TYPE});
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    public void onPacketSending(@NotNull PacketEvent packetEvent) {
        Player player = packetEvent.getPlayer();
        if (packetEvent.isCancelled() || !InventoryManager.playerIsLoaded((AnimalTamer)player) || this.isExtensionsNotNeededHere(player)) {
            return;
        }
        WrapperPlayServerWindowItems wrapperPlayServerWindowItems = new WrapperPlayServerWindowItems(packetEvent.getPacket());
        if (player.getOpenInventory().getType() == InventoryType.WORKBENCH) {
            List<ItemStack> list = wrapperPlayServerWindowItems.getSlotData();
            List<CraftExtension> list2 = CraftManager.getExtensions(player);
            for (CraftExtension craftExtension : list2) {
                for (int n : craftExtension.getSlots()) {
                    list.set(n, craftExtension.getCapItem());
                }
            }
            wrapperPlayServerWindowItems.setSlotData(list);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryOpen(@NotNull InventoryOpenEvent inventoryOpenEvent) {
        Player player = (Player)inventoryOpenEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || inventoryOpenEvent.getInventory().getType() != InventoryType.WORKBENCH || this.isExtensionsNotNeededHere(player)) {
            return;
        }
        player.updateInventory();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onInventoryClick(@NotNull InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || inventoryClickEvent.getInventory().getType() != InventoryType.WORKBENCH || this.isExtensionsNotNeededHere(player)) {
            return;
        }
        List<CraftExtension> list = CraftManager.getExtensions(player);
        for (CraftExtension craftExtension : list) {
            for (int n : craftExtension.getSlots()) {
                if (n != inventoryClickEvent.getRawSlot()) continue;
                inventoryClickEvent.setCancelled(true);
                PlayerUtils.updateInventory(player);
                return;
            }
        }
    }

    private boolean isExtensionsNotNeededHere(Player player) {
        return !InventoryManager.get((OfflinePlayer)player).isPocketCraft() && !Config.getConfig().getBoolean("craft.workbench", true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorkbenchClosed(@NotNull InventoryCloseEvent inventoryCloseEvent) {
        Player player = (Player)inventoryCloseEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        if (inventoryCloseEvent.getInventory().getType() == InventoryType.WORKBENCH) {
            InventoryManager.get((OfflinePlayer)player).onWorkbenchClosed();
        }
    }
}

