/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.event.listener;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.api.InventoryAPI;
import ru.endlesscode.rpginventory.inventory.ActionType;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.PlayerWrapper;
import ru.endlesscode.rpginventory.inventory.backpack.Backpack;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackHolder;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackManager;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackUpdater;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class BackpackListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onUseBackpack(@NotNull PlayerInteractEvent playerInteractEvent) {
        ItemStack itemStack = playerInteractEvent.getItem();
        if (!playerInteractEvent.hasItem() || !ItemUtils.hasTag(itemStack, "backpack.id")) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        Action action = playerInteractEvent.getAction();
        if ((action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) && InventoryManager.isQuickSlot(player.getInventory().getHeldItemSlot())) {
            BackpackManager.open(player, itemStack);
        }
        playerInteractEvent.setCancelled(true);
        player.updateInventory();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBackpackClick(@NotNull InventoryClickEvent inventoryClickEvent) {
        Inventory inventory = inventoryClickEvent.getInventory();
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        Slot slot = SlotManager.instance().getBackpackSlot();
        if (inventory.getHolder() instanceof BackpackHolder) {
            if (BackpackManager.isBackpack(inventoryClickEvent.getCurrentItem()) || BackpackManager.isBackpack(inventoryClickEvent.getCursor()) || InventoryManager.isFilledSlot(inventoryClickEvent.getCurrentItem()) || InventoryManager.isFilledSlot(inventoryClickEvent.getCursor())) {
                inventoryClickEvent.setCancelled(true);
                return;
            }
            if (inventoryClickEvent.getAction() == InventoryAction.NOTHING) {
                return;
            }
            BackpackUpdater.update(inventory, InventoryManager.get((OfflinePlayer)player).getBackpack());
        } else if (slot != null && (inventoryClickEvent.getRawSlot() >= inventoryClickEvent.getView().getTopInventory().getSize() || inventoryClickEvent.getSlot() == slot.getSlotId() && InventoryAPI.isRPGInventory(inventoryClickEvent.getInventory())) && BackpackManager.backpackLimitReached(player) && BackpackManager.isBackpack(inventoryClickEvent.getCursor()) && ActionType.getTypeOfAction(inventoryClickEvent.getAction()) == ActionType.SET) {
            int n = BackpackManager.getLimit();
            String string = RPGInventory.getLanguage().getMessage("backpack.limit", n);
            PlayerUtils.sendMessage(player, string);
            inventoryClickEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onBackpackClose(@NotNull InventoryCloseEvent inventoryCloseEvent) {
        Inventory inventory = inventoryCloseEvent.getInventory();
        Player player = (Player)inventoryCloseEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || !(inventory.getHolder() instanceof BackpackHolder)) {
            return;
        }
        PlayerWrapper playerWrapper = InventoryManager.get((OfflinePlayer)player);
        Backpack backpack = playerWrapper.getBackpack();
        if (backpack == null) {
            return;
        }
        backpack.onUse();
        playerWrapper.setBackpack(null);
    }

    @EventHandler(ignoreCancelled=true)
    public void onBackpackPickup(@NotNull EntityPickupItemEvent entityPickupItemEvent) {
        if (entityPickupItemEvent.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)entityPickupItemEvent.getEntity();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return;
        }
        if (BackpackManager.isBackpack(entityPickupItemEvent.getItem().getItemStack()) && BackpackManager.backpackLimitReached(player)) {
            int n = BackpackManager.getLimit();
            String string = RPGInventory.getLanguage().getMessage("backpack.limit", n);
            PlayerUtils.sendMessage(player, string);
            entityPickupItemEvent.setCancelled(true);
        }
    }
}

