/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.event.listener;

import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.api.InventoryAPI;
import ru.endlesscode.rpginventory.inventory.ActionType;
import ru.endlesscode.rpginventory.inventory.ArmorType;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.misc.config.VanillaSlotAction;
import ru.endlesscode.rpginventory.utils.InventoryUtils;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class ArmorEquipListener
implements Listener {
    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onQuickEquip(@NotNull PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || playerInteractEvent.getAction() != Action.RIGHT_CLICK_AIR && playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK || playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK && playerInteractEvent.getClickedBlock() != null && !playerInteractEvent.getClickedBlock().getState().getClass().getSimpleName().contains("BlockState")) {
            return;
        }
        ItemStack itemStack = playerInteractEvent.getItem();
        if (ItemUtils.isEmpty(itemStack)) {
            return;
        }
        ArmorType armorType = ArmorType.matchType(itemStack);
        if (InventoryUtils.playerNeedArmor(player, armorType)) {
            Slot slot = SlotManager.instance().getSlot(armorType.name());
            if (slot == null) {
                return;
            }
            playerInteractEvent.setCancelled(!InventoryManager.validateArmor(player, InventoryAction.PLACE_ONE, slot, itemStack));
            PlayerUtils.updateInventory(player);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDragEquip(@NotNull InventoryDragEvent inventoryDragEvent) {
        Player player = (Player)inventoryDragEvent.getWhoClicked();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || InventoryAPI.isRPGInventory(inventoryDragEvent.getInventory())) {
            return;
        }
        if (inventoryDragEvent.getRawSlots().size() == 1) {
            int n = (Integer)inventoryDragEvent.getRawSlots().toArray()[0];
            inventoryDragEvent.setCancelled(n >= 5 && n <= 8 && inventoryDragEvent.getInventory().getType() == InventoryType.CRAFTING);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onNormalEquip(@NotNull InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player) || InventoryAPI.isRPGInventory(inventoryClickEvent.getInventory()) || Config.armorSlotsAction == VanillaSlotAction.RPGINV) {
            return;
        }
        ActionType actionType = ActionType.getTypeOfAction(inventoryClickEvent.getAction());
        if (actionType == ActionType.SET && inventoryClickEvent.getSlotType() != InventoryType.SlotType.ARMOR) {
            return;
        }
        if (InventoryManager.get((OfflinePlayer)player).isFlying()) {
            PlayerUtils.sendMessage(player, RPGInventory.getLanguage().getMessage("error.fall"));
            inventoryClickEvent.setCancelled(true);
            return;
        }
        if (actionType == ActionType.SET) {
            ItemStack itemStack = inventoryClickEvent.getCursor();
            Slot slot = ArmorType.getArmorSlotById(inventoryClickEvent.getRawSlot());
            if (slot == null || ItemUtils.isEmpty(itemStack)) {
                return;
            }
            inventoryClickEvent.setCancelled(!InventoryManager.validateArmor(player, inventoryClickEvent.getAction(), slot, itemStack));
        } else if (inventoryClickEvent.getAction() == InventoryAction.HOTBAR_SWAP) {
            ItemStack itemStack;
            if (inventoryClickEvent.getInventory().getType() == InventoryType.CRAFTING && ItemUtils.isNotEmpty(itemStack = player.getInventory().getItem(inventoryClickEvent.getHotbarButton()))) {
                inventoryClickEvent.setCancelled(true);
            }
        } else if (inventoryClickEvent.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            ItemStack itemStack = inventoryClickEvent.getCurrentItem();
            ArmorType armorType = ArmorType.matchType(itemStack);
            if (armorType == ArmorType.UNKNOWN) {
                return;
            }
            Slot slot = SlotManager.instance().getSlot(armorType.name());
            if (slot != null && InventoryUtils.playerNeedArmor(player, armorType)) {
                inventoryClickEvent.setCancelled(!InventoryManager.validateArmor(player, InventoryAction.PLACE_ONE, slot, itemStack));
            }
        }
    }

    @EventHandler
    public void onDispenseEquip(BlockDispenseEvent blockDispenseEvent) {
        Location location;
        ArmorType armorType = ArmorType.matchType(blockDispenseEvent.getItem());
        World world = blockDispenseEvent.getBlock().getWorld();
        Collection collection = world.getNearbyEntities(location = blockDispenseEvent.getBlock().getLocation(), 3.0, 1.2, 3.0);
        if (collection.isEmpty()) {
            return;
        }
        for (Entity entity : collection) {
            if (entity.getType() != EntityType.PLAYER) continue;
            Player player = (Player)entity;
            if (!this.isPlayerInRightPosition(blockDispenseEvent.getBlock(), player) || this.hasInventoryArmorByType(armorType, player) || !InventoryManager.playerIsLoaded((AnimalTamer)player)) continue;
            Slot slot = SlotManager.instance().getSlot(armorType.name());
            blockDispenseEvent.setCancelled(slot != null && !InventoryManager.validateArmor(player, InventoryAction.PLACE_ONE, slot, blockDispenseEvent.getItem()));
            return;
        }
    }

    private boolean hasInventoryArmorByType(ArmorType armorType, Player player) {
        switch (armorType) {
            case HELMET: {
                return player.getInventory().getHelmet() != null;
            }
            case CHESTPLATE: {
                return player.getInventory().getChestplate() != null;
            }
            case LEGGINGS: {
                return player.getInventory().getLeggings() != null;
            }
            case BOOTS: {
                return player.getInventory().getBoots() != null;
            }
        }
        return true;
    }

    private boolean isPlayerInRightPosition(Block block, Player player) {
        if (!(block.getState() instanceof Dispenser)) {
            return false;
        }
        Location location = block.getLocation();
        Location location2 = player.getLocation();
        Dispenser dispenser = (Dispenser)block.getState();
        Directional directional = (Directional)dispenser.getBlockData();
        switch (directional.getFacing()) {
            case EAST: {
                return location2.getBlockX() != location.getBlockX() && location2.getX() <= location.getX() + 2.3 && location2.getX() >= location.getX();
            }
            case WEST: {
                return location2.getX() >= location.getX() - 1.3 && location2.getX() <= location.getX();
            }
            case SOUTH: {
                return location2.getBlockZ() != location.getBlockZ() && location2.getZ() <= location.getZ() + 2.3 && location2.getZ() >= location.getZ();
            }
            case NORTH: {
                return location2.getZ() >= location.getZ() - 1.3 && location2.getZ() <= location.getZ();
            }
        }
        return false;
    }
}

