/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.compat;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import ru.endlesscode.rpginventory.utils.Version;

public class VersionHandler {
    public static final int VERSION_1_11 = 11100;
    public static final int VERSION_1_12 = 11200;
    public static final int VERSION_1_13 = 11300;
    public static final int VERSION_1_14 = 11400;
    public static final int VERSION_1_15 = 11500;
    public static final int VERSION_1_16 = 11600;
    private static final Pattern pattern = Pattern.compile("(?<version>\\d\\.\\d{1,2}(\\.\\d)?)-.*");
    private static int versionCode = -1;

    public static boolean isNotSupportedVersion() {
        return VersionHandler.getVersionCode() < 11400 || VersionHandler.getVersionCode() >= 11600;
    }

    public static boolean isExperimentalSupport() {
        return VersionHandler.getVersionCode() >= 11500;
    }

    public static boolean isLegacy() {
        return VersionHandler.getVersionCode() < 11300;
    }

    public static int getVersionCode() {
        if (versionCode == -1) {
            VersionHandler.initVersionCode();
        }
        return versionCode;
    }

    private static void initVersionCode() {
        Matcher matcher = pattern.matcher(Bukkit.getBukkitVersion());
        if (matcher.find()) {
            String string = matcher.group("version");
            versionCode = Version.parseVersion(string).getVersionCode();
        } else {
            versionCode = 0;
        }
    }
}

