/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory.api;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.PlayerWrapper;
import ru.endlesscode.rpginventory.inventory.slot.Slot;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

public class InventoryAPI {
    public static boolean isRPGInventory(Inventory inventory) {
        InventoryHolder inventoryHolder = inventory.getHolder();
        return inventoryHolder instanceof PlayerWrapper;
    }

    @NotNull
    public static List<ItemStack> getPassiveItems(Player player) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return arrayList;
        }
        Inventory inventory = InventoryManager.get((OfflinePlayer)player).getInventory();
        for (Slot slot : SlotManager.instance().getPassiveSlots()) {
            for (int n : slot.getSlotIds()) {
                ItemStack itemStack = inventory.getItem(n);
                if (!ItemUtils.isNotEmpty(itemStack) || InventoryManager.isEmptySlot(itemStack)) continue;
                arrayList.add(itemStack);
            }
        }
        return arrayList;
    }

    @NotNull
    public static List<ItemStack> getActiveItems(Player player) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            return arrayList;
        }
        Inventory inventory = InventoryManager.get((OfflinePlayer)player).getInventory();
        for (Slot slot : SlotManager.instance().getActiveSlots()) {
            ItemStack itemStack = inventory.getItem(slot.getSlotId());
            if (!ItemUtils.isNotEmpty(itemStack) || InventoryManager.isQuickEmptySlot(itemStack)) continue;
            arrayList.add(itemStack);
        }
        return arrayList;
    }
}

