/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory;

import java.util.List;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import ru.endlesscode.rpginventory.RPGInventory;
import ru.endlesscode.rpginventory.api.InventoryAPI;
import ru.endlesscode.rpginventory.event.ItemCommandEvent;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackManager;
import ru.endlesscode.rpginventory.item.ItemManager;
import ru.endlesscode.rpginventory.pet.PetManager;
import ru.endlesscode.rpginventory.utils.ItemUtils;
import ru.endlesscode.rpginventory.utils.StringUtils;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;

final class RPGInventoryCommandExecutor
implements CommandExecutor {
    RPGInventoryCommandExecutor() {
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String string, @NotNull String[] stringArray) {
        if (stringArray.length == 0) {
            this.printHelp(commandSender);
            return true;
        }
        Permission permission = RPGInventory.getPermissions();
        String string2 = stringArray[0].toLowerCase();
        if (permission.has(commandSender, "rpginventory.admin")) {
            switch (string2.charAt(0)) {
                case 'p': {
                    this.tryToGivePet(commandSender, stringArray);
                    return true;
                }
                case 'f': {
                    this.tryToGiveFood(commandSender, stringArray);
                    return true;
                }
                case 'i': {
                    this.tryToGiveItem(commandSender, stringArray);
                    return true;
                }
                case 'b': {
                    this.tryToGiveBackpack(commandSender, stringArray);
                    return true;
                }
                case 'l': {
                    this.onCommandList(commandSender);
                    return true;
                }
                case 'r': {
                    this.reloadPlugin(commandSender);
                    return true;
                }
            }
        }
        if (string2.charAt(0) == 'o') {
            if (stringArray.length == 1 && permission.has(commandSender, "rpginventory.open")) {
                this.openInventory(commandSender);
            } else if (stringArray.length > 1 && permission.has(commandSender, "rpginventory.open.others")) {
                this.openInventory(commandSender, stringArray[1]);
            } else {
                this.missingRights(commandSender);
            }
        } else {
            this.printHelp(commandSender);
        }
        return true;
    }

    private void tryToGivePet(CommandSender commandSender, String[] stringArray) {
        if (stringArray.length == 1) {
            this.printPetsList(commandSender);
        } else if (stringArray.length >= 3 && this.validatePlayer(commandSender, stringArray[1])) {
            this.givePet(commandSender, stringArray[1], stringArray[2]);
            return;
        }
        commandSender.sendMessage(StringUtils.coloredLine("&3Usage: &6/rpginv pet [&eplayer&6] [&epetId&6]"));
    }

    private void tryToGiveFood(CommandSender commandSender, String[] stringArray) {
        if (stringArray.length == 1) {
            this.printFoodList(commandSender);
        } else if (stringArray.length >= 3 && this.validatePlayer(commandSender, stringArray[1])) {
            this.giveFood(commandSender, stringArray[1], stringArray[2], stringArray.length > 3 ? stringArray[3] : "1");
            return;
        }
        commandSender.sendMessage(StringUtils.coloredLine("&3Usage: &6/rpginv food [&eplayer&6] [&efoodId&6] (&eamount&6)"));
    }

    private void tryToGiveItem(CommandSender commandSender, String[] stringArray) {
        if (stringArray.length == 1) {
            this.printItemsList(commandSender);
        } else if (stringArray.length >= 3 && this.validatePlayer(commandSender, stringArray[1])) {
            this.giveItem(commandSender, stringArray[1], stringArray[2]);
            return;
        }
        commandSender.sendMessage(StringUtils.coloredLine("&3Usage: &6/rpginv item [&eplayer&6] [&eitemId&6]"));
    }

    private void tryToGiveBackpack(CommandSender commandSender, String[] stringArray) {
        if (stringArray.length == 1) {
            this.printBackpacksList(commandSender);
        } else if (stringArray.length >= 3 && this.validatePlayer(commandSender, stringArray[1])) {
            this.giveBackpack(commandSender, stringArray[1], stringArray[2]);
            return;
        }
        commandSender.sendMessage(StringUtils.coloredLine("&3Usage: &6/rpginv bp [&eplayer&6] [&eitemId&6]"));
    }

    private void givePet(@NotNull CommandSender commandSender, String string, String string2) {
        Player player = RPGInventory.getInstance().getServer().getPlayer(string);
        ItemStack itemStack = PetManager.getPetItem(string2);
        String string3 = "Pet '" + string2 + "'";
        if (ItemUtils.isEmpty(itemStack)) {
            commandSender.sendMessage(StringUtils.coloredLine("&c" + string3 + " not found!"));
            this.printPetsList(commandSender);
        } else {
            this.giveItemToPlayer(commandSender, player, itemStack, string3);
        }
    }

    private void giveFood(@NotNull CommandSender commandSender, String string, String string2, @NotNull String string3) {
        Player player = RPGInventory.getInstance().getServer().getPlayer(string);
        ItemStack itemStack = PetManager.getFoodItem(string2);
        String string4 = "Food '" + string2 + "'";
        if (ItemUtils.isEmpty(itemStack)) {
            commandSender.sendMessage(StringUtils.coloredLine("&c" + string4 + " not found!"));
            this.printFoodList(commandSender);
        } else {
            try {
                int n = Integer.parseInt(string3);
                itemStack.setAmount(n);
                this.giveItemToPlayer(commandSender, player, itemStack, string4);
            }
            catch (NumberFormatException numberFormatException) {
                commandSender.sendMessage(StringUtils.coloredLine("&cThe amount must be a number!"));
            }
        }
    }

    private void giveItem(@NotNull CommandSender commandSender, String string, String string2) {
        Player player = RPGInventory.getInstance().getServer().getPlayer(string);
        ItemStack itemStack = ItemManager.getItem(string2);
        String string3 = "Item '" + string2 + "'";
        if (ItemUtils.isEmpty(itemStack)) {
            commandSender.sendMessage(StringUtils.coloredLine("&c" + string3 + " not found!"));
            this.printItemsList(commandSender);
        } else {
            this.giveItemToPlayer(commandSender, player, itemStack, string3);
        }
    }

    private void giveBackpack(@NotNull CommandSender commandSender, String string, String string2) {
        Player player = RPGInventory.getInstance().getServer().getPlayer(string);
        ItemStack itemStack = BackpackManager.getItem(string2);
        String string3 = "Backpack '" + string2 + "'";
        if (ItemUtils.isEmpty(itemStack)) {
            commandSender.sendMessage(StringUtils.coloredLine("&c" + string3 + " not found!"));
            this.printBackpacksList(commandSender);
        } else {
            this.giveItemToPlayer(commandSender, player, itemStack, string3);
        }
    }

    private void printPetsList(@NotNull CommandSender commandSender) {
        this.printList(commandSender, PetManager.getPetList(), "Pets");
    }

    private void giveItemToPlayer(@NotNull CommandSender commandSender, Player player, ItemStack itemStack, String string) {
        ItemCommandEvent itemCommandEvent = new ItemCommandEvent(player, itemStack);
        Bukkit.getPluginManager().callEvent((Event)itemCommandEvent);
        String string2 = itemCommandEvent.isCancelled() ? "&cItem command was cancelled" : (player.getInventory().addItem(new ItemStack[]{itemCommandEvent.getItem()}).isEmpty() ? "&3" + string + " has been given to " + player.getName() : "&c" + player.getName() + " has no empty slots in the inventory.");
        commandSender.sendMessage(StringUtils.coloredLine(string2));
    }

    private void printFoodList(@NotNull CommandSender commandSender) {
        this.printList(commandSender, PetManager.getFoodList(), "Food");
    }

    private void printItemsList(@NotNull CommandSender commandSender) {
        this.printList(commandSender, ItemManager.getItemList(), "Items");
    }

    private void printBackpacksList(@NotNull CommandSender commandSender) {
        this.printList(commandSender, BackpackManager.getBackpackList(), "Backpacks");
    }

    private void printList(@NotNull CommandSender commandSender, List<String> list, String string) {
        String string2 = String.format(list.isEmpty() ? "&c%s not found..." : "&3%s list: &6" + list, string);
        commandSender.sendMessage(StringUtils.coloredLine(string2));
    }

    private void onCommandList(@NotNull CommandSender commandSender) {
        commandSender.sendMessage(StringUtils.coloredLine("&cCommand &6/rpginv list [&etype&6]&c was removed."));
        commandSender.sendMessage(StringUtils.coloredLine("&3Use &6/rpginv [&epets&6|&efood&6|&eitems&6|&ebackpacks&6]&3 instead."));
    }

    private void reloadPlugin(CommandSender commandSender) {
        PluginManager pluginManager = RPGInventory.getInstance().getServer().getPluginManager();
        pluginManager.disablePlugin((Plugin)RPGInventory.getInstance());
        pluginManager.enablePlugin((Plugin)RPGInventory.getInstance());
        commandSender.sendMessage(StringUtils.coloredLine("&e[RPGInventory] Plugin successfully reloaded!"));
    }

    private void printHelp(CommandSender commandSender) {
        commandSender.sendMessage(StringUtils.coloredLine("&3===================&b[&eRPGInventory&b]&3====================="));
        commandSender.sendMessage(StringUtils.coloredLine("&8[] &7Required, &8() &7Optional"));
        if (RPGInventory.getPermissions().has(commandSender, "rpginventory.open.others")) {
            commandSender.sendMessage(StringUtils.coloredLine("&6rpginv open (&eplayer&6) &7- open inventory"));
        } else if (RPGInventory.getPermissions().has(commandSender, "rpginventory.open")) {
            commandSender.sendMessage(StringUtils.coloredLine("&6rpginv open &7- open inventory"));
        }
        if (RPGInventory.getPermissions().has(commandSender, "rpginventory.admin")) {
            commandSender.sendMessage(StringUtils.coloredLine("&6rpginv reload &7- reload config"));
            commandSender.sendMessage(StringUtils.coloredLine("&6rpginv [&epets&6|&efood&6|&eitems&6|&ebackpacks&6] &7- show list of pets, items etc."));
            commandSender.sendMessage(StringUtils.coloredLine("&6rpginv food [&eplayer&6] [&efoodId&6] (&eamount&6) &7- gives food to player"));
            commandSender.sendMessage(StringUtils.coloredLine("&6rpginv pet [&eplayer&6] [&epetId&6] &7- gives pet to player"));
            commandSender.sendMessage(StringUtils.coloredLine("&6rpginv item [&eplayer&6] [&eitemId&6] &7- gives item to player"));
            commandSender.sendMessage(StringUtils.coloredLine("&6rpginv bp [&eplayer&6] [&ebackpackId&6] &7- gives backpack to player"));
        }
        commandSender.sendMessage(StringUtils.coloredLine("&3====================================================="));
    }

    private void openInventory(@NotNull CommandSender commandSender) {
        if (!this.validatePlayer(commandSender)) {
            return;
        }
        Player player = (Player)commandSender;
        if (InventoryAPI.isRPGInventory(player.getOpenInventory().getTopInventory())) {
            return;
        }
        InventoryManager.get((OfflinePlayer)player).openInventory();
    }

    private void openInventory(@NotNull CommandSender commandSender, String string) {
        if (!this.validatePlayer(commandSender) || !this.validatePlayer(commandSender, string)) {
            return;
        }
        Player player = RPGInventory.getInstance().getServer().getPlayer(string);
        assert (player != null);
        ((Player)commandSender).openInventory(InventoryManager.get((OfflinePlayer)player).getInventory());
    }

    private boolean validatePlayer(CommandSender commandSender) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(StringUtils.coloredLine("&cThis command not allowed from console."));
            return false;
        }
        return this.validatePlayer(commandSender, (Player)commandSender);
    }

    private boolean validatePlayer(@NotNull CommandSender commandSender, String string) {
        Player player = RPGInventory.getInstance().getServer().getPlayer(string);
        if (player == null) {
            commandSender.sendMessage(StringUtils.coloredLine("&cPlayer '" + string + "' not found!"));
        }
        return this.validatePlayer(commandSender, player);
    }

    private boolean validatePlayer(@NotNull CommandSender commandSender, Player player) {
        if (!InventoryManager.playerIsLoaded((AnimalTamer)player)) {
            commandSender.sendMessage(StringUtils.coloredLine("&cThis command not allowed here."));
            return false;
        }
        return true;
    }

    private void missingRights(CommandSender commandSender) {
        commandSender.sendMessage(RPGInventory.getLanguage().getMessage("message.perms"));
        this.printHelp(commandSender);
    }
}

