/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.rpginventory;

import java.nio.file.Path;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import ru.endlesscode.rpginventory.RPGInventoryCommandExecutor;
import ru.endlesscode.rpginventory.compat.VersionHandler;
import ru.endlesscode.rpginventory.event.listener.ArmorEquipListener;
import ru.endlesscode.rpginventory.event.listener.ElytraListener;
import ru.endlesscode.rpginventory.event.listener.HandSwapListener;
import ru.endlesscode.rpginventory.event.listener.PlayerListener;
import ru.endlesscode.rpginventory.event.listener.WorldListener;
import ru.endlesscode.rpginventory.inventory.InventoryLocker;
import ru.endlesscode.rpginventory.inventory.InventoryManager;
import ru.endlesscode.rpginventory.inventory.backpack.BackpackManager;
import ru.endlesscode.rpginventory.inventory.craft.CraftManager;
import ru.endlesscode.rpginventory.inventory.slot.SlotManager;
import ru.endlesscode.rpginventory.item.ItemManager;
import ru.endlesscode.rpginventory.misc.FileLanguage;
import ru.endlesscode.rpginventory.misc.Updater;
import ru.endlesscode.rpginventory.misc.config.Config;
import ru.endlesscode.rpginventory.misc.config.ConfigUpdater;
import ru.endlesscode.rpginventory.misc.serialization.Serialization;
import ru.endlesscode.rpginventory.pet.PetManager;
import ru.endlesscode.rpginventory.pet.mypet.MyPetManager;
import ru.endlesscode.rpginventory.resourcepack.ResourcePackModule;
import ru.endlesscode.rpginventory.utils.Log;
import ru.endlesscode.rpginventory.utils.PlayerUtils;
import ru.endlesscode.rpginventory.utils.SafeEnums;
import ru.endlesscode.rpginventory.utils.StringUtils;
import ru.endlesscode.rpginventory.utils.Version;
import shade.ru.endlesscode.rpginventory.annotations.Contract;
import shade.ru.endlesscode.rpginventory.annotations.NotNull;
import shade.ru.endlesscode.rpginventory.annotations.Nullable;
import shade.ru.endlesscode.rpginventory.bstats.MetricsLite;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.command.TrackedCommandExecutor;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.plugin.PluginLifecycle;
import shade.ru.endlesscode.rpginventory.inspector.bukkit.scheduler.TrackedBukkitRunnable;

public class RPGInventory
extends PluginLifecycle {
    private static RPGInventory instance;
    private Permission perms;
    private Economy economy;
    private PlayerUtils.LevelSystem levelSystem;
    private PlayerUtils.ClassSystem classSystem;
    private FileLanguage language;
    private boolean placeholderApiHooked = false;
    private boolean myPetHooked = false;
    private ResourcePackModule resourcePackModule = null;

    public static RPGInventory getInstance() {
        return instance;
    }

    public static FileLanguage getLanguage() {
        return RPGInventory.instance.language;
    }

    public static Permission getPermissions() {
        return RPGInventory.instance.perms;
    }

    public static Economy getEconomy() {
        return RPGInventory.instance.economy;
    }

    @Contract(pure=true)
    public static boolean economyConnected() {
        return RPGInventory.instance.economy != null;
    }

    @Contract(pure=true)
    public static boolean isPlaceholderApiHooked() {
        return RPGInventory.instance.placeholderApiHooked;
    }

    @Contract(pure=true)
    public static boolean isMyPetHooked() {
        return RPGInventory.instance.myPetHooked;
    }

    public static PlayerUtils.LevelSystem getLevelSystem() {
        return RPGInventory.instance.levelSystem;
    }

    public static PlayerUtils.ClassSystem getClassSystem() {
        return RPGInventory.instance.classSystem;
    }

    @Nullable
    public static ResourcePackModule getResourcePackModule() {
        return RPGInventory.instance.resourcePackModule;
    }

    @Override
    public void init() {
        instance = this;
        Log.init(this.getLogger());
        Config.init(this);
    }

    @Override
    public void onEnable() {
        this.updateConfig();
        Config.reload();
        this.language = new FileLanguage(this);
        Serialization.registerTypes();
        if (!this.checkRequirements()) {
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new StringUtils.Placeholders().register();
            this.placeholderApiHooked = true;
            Log.i("Placeholder API hooked!", new Object[0]);
        } else {
            this.placeholderApiHooked = false;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("MyPet") && MyPetManager.init(this)) {
            this.myPetHooked = true;
            Log.i("MyPet used as pet system", new Object[0]);
        } else {
            this.myPetHooked = false;
            Log.i(PetManager.init(this) ? "Pet system is enabled" : "Pet system isn''t loaded", new Object[0]);
        }
        Log.i(CraftManager.init(this) ? "Craft extensions is enabled" : "Craft extensions isn''t loaded", new Object[0]);
        Log.i(InventoryLocker.init(this) ? "Inventory lock system is enabled" : "Inventory lock system isn''t loaded", new Object[0]);
        Log.i(ItemManager.init(this) ? "Item system is enabled" : "Item system isn''t loaded", new Object[0]);
        Log.i(BackpackManager.init(this) ? "Backpack system is enabled" : "Backpack system isn''t loaded", new Object[0]);
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new ArmorEquipListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new HandSwapListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new WorldListener(), (Plugin)this);
        if (SlotManager.instance().getElytraSlot() != null) {
            pluginManager.registerEvents((Listener)new ElytraListener(), (Plugin)this);
        }
        this.resourcePackModule = ResourcePackModule.init((Plugin)this);
        this.loadPlayers();
        this.startMetrics();
        this.getCommand("rpginventory").setExecutor((CommandExecutor)new TrackedCommandExecutor(new RPGInventoryCommandExecutor(), this.getReporter()));
        this.checkUpdates(null);
        new TrackedBukkitRunnable(){

            public void run() {
                RPGInventory.this.checkThatSystemsLoaded();
            }
        }.runTask((Plugin)this);
    }

    private boolean checkRequirements() {
        if (!Config.getConfig().getBoolean("enabled")) {
            Log.w("RPGInventory is disabled in the config!", new Object[0]);
            return false;
        }
        if (VersionHandler.isNotSupportedVersion()) {
            Log.w("This version of RPG Inventory is not tested with \"{0}\"!", Bukkit.getBukkitVersion());
        } else if (VersionHandler.isExperimentalSupport()) {
            Log.w("Support of {0} is experimental! Use RPGInventory with caution.", Bukkit.getBukkitVersion());
        }
        if (!this.setupPermissions()) {
            Log.s("Permissions not found!", new Object[0]);
            return false;
        }
        Log.i("Permissions hooked: {0}", this.perms.getName());
        if (this.setupEconomy()) {
            Log.i("Economy hooked: {0}", this.economy.getName());
        } else {
            Log.w("Economy not found!", new Object[0]);
        }
        this.initLevelSystem();
        this.initClassSystem();
        return InventoryManager.init(this) && SlotManager.init();
    }

    private void initLevelSystem() {
        this.levelSystem = SafeEnums.valueOfOrDefault(PlayerUtils.LevelSystem.class, Config.getConfig().getString("level-system"), PlayerUtils.LevelSystem.EXP, "level system");
    }

    private void initClassSystem() {
        this.classSystem = SafeEnums.valueOfOrDefault(PlayerUtils.ClassSystem.class, Config.getConfig().getString("class-system"), PlayerUtils.ClassSystem.PERMISSIONS, "class-system");
    }

    private void checkThatSystemsLoaded() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (this.levelSystem != PlayerUtils.LevelSystem.EXP && !pluginManager.isPluginEnabled(this.levelSystem.getPluginName())) {
            Log.w("Level-system {0} is not enabled!", this.levelSystem.getPluginName());
            Log.w("Will be used EXP by default", new Object[0]);
            this.levelSystem = PlayerUtils.LevelSystem.EXP;
        }
        if (this.classSystem != PlayerUtils.ClassSystem.PERMISSIONS && !pluginManager.isPluginEnabled(this.classSystem.getPluginName())) {
            Log.w("Class-system {0} is not enabled!", this.classSystem.getPluginName());
            Log.w("Will be used PERMISSIONS by default", new Object[0]);
            this.classSystem = PlayerUtils.ClassSystem.PERMISSIONS;
        }
    }

    @Override
    public void onDisable() {
        BackpackManager.saveBackpacks();
        this.savePlayers();
    }

    private void startMetrics() {
        new MetricsLite((Plugin)this);
    }

    private void savePlayers() {
        if (this.getServer().getOnlinePlayers().size() == 0) {
            return;
        }
        Log.i("Saving players inventories...", new Object[0]);
        for (Player player : this.getServer().getOnlinePlayers()) {
            InventoryManager.unloadPlayerInventory(player);
        }
    }

    private void loadPlayers() {
        if (this.getServer().getOnlinePlayers().size() == 0) {
            return;
        }
        Log.i("Loading players inventories...", new Object[0]);
        for (Player player : this.getServer().getOnlinePlayers()) {
            InventoryManager.loadPlayerInventory(player);
        }
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (registeredServiceProvider != null) {
            this.perms = (Permission)registeredServiceProvider.getProvider();
        }
        return this.perms != null;
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider != null) {
            this.economy = (Economy)registeredServiceProvider.getProvider();
        }
        return this.economy != null;
    }

    public void checkUpdates(final @Nullable Player player) {
        if (!Config.getConfig().getBoolean("check-update")) {
            return;
        }
        new TrackedBukkitRunnable(){

            public void run() {
                Updater updater = new Updater((Plugin)instance, Updater.UpdateType.NO_DOWNLOAD);
                if (updater.getResult() == Updater.UpdateResult.UPDATE_AVAILABLE) {
                    String[] stringArray;
                    for (String string : stringArray = new String[]{StringUtils.coloredLine("&3=================&b[&eRPGInventory&b]&3==================="), StringUtils.coloredLine("&6New version available: &a" + updater.getLatestName() + "&6!"), StringUtils.coloredLine(updater.getDescription()), StringUtils.coloredLine("&6Changelog: &e" + updater.getInfoLink()), StringUtils.coloredLine("&6Download it on &eSpigotMC&6!"), StringUtils.coloredLine("&3==================================================")}) {
                        if (player == null) {
                            StringUtils.coloredConsole(string);
                            continue;
                        }
                        PlayerUtils.sendMessage(player, string);
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)RPGInventory.getInstance());
    }

    private void updateConfig() {
        Version version = Version.parseVersion(this.getDescription().getVersion());
        if (!Config.getConfig().contains("version")) {
            Config.getConfig().set("version", (Object)version.toString());
            Config.save();
            return;
        }
        Version version2 = Version.parseVersion(Config.getConfig().getString("version"));
        if (version.compareTo(version2) > 0) {
            ConfigUpdater.update(version2);
            Config.getConfig().set("version", null);
            Config.getConfig().set("version", (Object)version.toString());
            Config.save();
        }
    }

    @NotNull
    public Path getDataPath() {
        return this.getDataFolder().toPath();
    }
}

