/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.tick;

import eu.decentsoftware.holograms.api.utils.DExecutor;
import eu.decentsoftware.holograms.api.utils.collection.DList;
import eu.decentsoftware.holograms.api.utils.scheduler.S;
import eu.decentsoftware.holograms.api.utils.tick.ITicked;
import java.util.concurrent.atomic.AtomicLong;

public class Ticker {
    private final int taskId;
    private final AtomicLong ticks = new AtomicLong(0L);
    private final DList<ITicked> tickedObjects = new DList(1024);
    private final DList<ITicked> newTickedObjects = new DList(64);
    private final DList<String> removeTickedObjects = new DList(64);
    private volatile boolean performingTick = false;

    public Ticker() {
        this.taskId = S.asyncTask(() -> {
            if (!this.performingTick) {
                this.tick();
            }
        }, 1L, 5L).getTaskId();
    }

    public void destroy() {
        S.stopTask(this.taskId);
        this.tickedObjects.clear();
        this.newTickedObjects.clear();
        this.removeTickedObjects.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ITicked ticked) {
        DList<ITicked> dList = this.newTickedObjects;
        synchronized (dList) {
            if (this.tickedObjects.contains(ticked)) {
                return;
            }
            if (!this.newTickedObjects.contains(ticked)) {
                this.newTickedObjects.add(ticked);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String id) {
        DList<String> dList = this.removeTickedObjects;
        synchronized (dList) {
            if (!this.removeTickedObjects.contains(id)) {
                this.removeTickedObjects.add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        this.performingTick = true;
        DExecutor e = DExecutor.create(this.tickedObjects.size());
        DList<Object> dList = this.tickedObjects;
        synchronized (dList) {
            for (ITicked ticked : this.tickedObjects) {
                if (!ticked.shouldTick(this.ticks.get())) continue;
                e.queue(() -> {
                    try {
                        ticked.tick();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                });
            }
        }
        dList = this.removeTickedObjects;
        synchronized (dList) {
            block10: while (this.removeTickedObjects.hasElements()) {
                String id = this.removeTickedObjects.popRandom();
                for (int i = 0; i < this.tickedObjects.size(); ++i) {
                    if (!((ITicked)this.tickedObjects.get(i)).getId().equals(id)) continue;
                    this.tickedObjects.remove(i);
                    continue block10;
                }
            }
        }
        dList = this.newTickedObjects;
        synchronized (dList) {
            while (this.newTickedObjects.hasElements()) {
                this.tickedObjects.add(this.newTickedObjects.pop());
            }
        }
        this.performingTick = false;
        this.ticks.incrementAndGet();
    }
}

