/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.reflect;

import java.lang.reflect.Field;
import org.bukkit.Bukkit;

public final class ReflectionUtil {
    private static String version;

    public static String getVersion() {
        if (version == null) {
            version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        }
        return version;
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class<?> getNMClass(String name) {
        try {
            return Class.forName("net.minecraft." + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class<?> getNMSClass(String name) {
        try {
            return Class.forName("net.minecraft.server." + ReflectionUtil.getVersion() + "." + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class<?> getObcClass(String classname) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + ReflectionUtil.getVersion() + "." + classname);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> boolean setFieldValue(Object object, String fieldName, T value) {
        Class<?> clazz = object.getClass();
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return false;
        }
    }

    private ReflectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

