/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.location;

import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.RandomUtils;
import eu.decentsoftware.holograms.api.utils.exception.LocationParseException;
import java.util.UUID;
import java.util.logging.Level;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.Nullable;

public final class LocationUtils {
    public static String asString(@NonNull Location l, boolean includeYawPitch) {
        if (l == null) {
            throw new NullPointerException("l is marked non-null but is null");
        }
        String location = String.format("%s:%.3f:%.3f:%.3f", l.getWorld().getName(), l.getX(), l.getY(), l.getZ());
        if (includeYawPitch) {
            location = location + String.format(":%.3f:%.3f", Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()));
        }
        return location;
    }

    @Nullable
    public static Location asLocation(String string) {
        return LocationUtils.asLocation(string, ":");
    }

    @Nullable
    public static Location asLocation(String string, String separator) {
        try {
            return LocationUtils.asLocationE(string, separator);
        }
        catch (LocationParseException e) {
            Common.log(Level.WARNING, "Error while parsing Location %s: %s", string, e.getMessage());
            return null;
        }
    }

    public static Location asLocationE(String string) throws LocationParseException {
        return LocationUtils.asLocationE(string, ":");
    }

    public static Location asLocationE(String string, String separator) throws LocationParseException {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        String[] spl = string.replace(",", ".").split(separator);
        if (spl.length >= 4) {
            World world = LocationUtils.getWorld(spl[0]);
            if (world != null) {
                try {
                    Location location = new Location(world, Double.parseDouble(spl[1]), Double.parseDouble(spl[2]), Double.parseDouble(spl[3]));
                    if (spl.length >= 6) {
                        location.setYaw(Float.parseFloat(spl[4]));
                        location.setPitch(Float.parseFloat(spl[5]));
                    }
                    return location;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            throw new LocationParseException(String.format("World '%s' not found.", spl[0]), LocationParseException.Reason.WORLD, spl[0]);
        }
        throw new LocationParseException(String.format("Wrong location format: %s", string));
    }

    public static Location randomizeLocation(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return location.add((double)RandomUtils.randomFloat() - 0.5, (double)RandomUtils.randomFloat() - 0.5, (double)RandomUtils.randomFloat() - 0.5);
    }

    public static double distance2D(@NonNull Location location1, @NonNull Location location2) {
        if (location1 == null) {
            throw new NullPointerException("location1 is marked non-null but is null");
        }
        if (location2 == null) {
            throw new NullPointerException("location2 is marked non-null but is null");
        }
        return Math.sqrt(NumberConversions.square((double)(location1.getX() - location2.getX())) + NumberConversions.square((double)(location1.getZ() - location2.getZ())));
    }

    private static World getWorld(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        UUID uuid = null;
        try {
            uuid = UUID.fromString(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uuid == null ? Bukkit.getWorld((String)value) : Bukkit.getWorld((UUID)uuid);
    }

    private LocationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

