/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.items;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.Collection;
import java.util.UUID;
import lombok.NonNull;
import org.bukkit.SkullType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;

public final class SkullUtils {
    private static Field PROFILE_FIELD;
    private static Method SET_PROFILE_METHOD;
    private static boolean INITIALIZED;

    @Nullable
    public static String getSkullTexture(@NonNull ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        try {
            GameProfile profile;
            ItemMeta meta = itemStack.getItemMeta();
            if (!(meta instanceof SkullMeta)) {
                return null;
            }
            if (PROFILE_FIELD == null) {
                PROFILE_FIELD = meta.getClass().getDeclaredField("profile");
                PROFILE_FIELD.setAccessible(true);
            }
            if ((profile = (GameProfile)PROFILE_FIELD.get(meta)) == null) {
                return null;
            }
            PropertyMap properties = profile.getProperties();
            Collection property = properties.get((Object)"textures");
            if (property != null && !property.isEmpty()) {
                return ((Property)property.stream().findFirst().get()).getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static String getTexture(@NonNull ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        return SkullUtils.getSkullTexture(itemStack);
    }

    public static void setSkullTexture(@NonNull ItemStack itemStack, @NonNull String texture) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (texture == null) {
            throw new NullPointerException("texture is marked non-null but is null");
        }
        try {
            ItemMeta meta = itemStack.getItemMeta();
            if (meta instanceof SkullMeta) {
                GameProfile profile = new GameProfile(UUID.randomUUID(), null);
                Property property = new Property("textures", texture);
                PropertyMap properties = profile.getProperties();
                properties.put((Object)"textures", (Object)property);
                if (SET_PROFILE_METHOD == null && !INITIALIZED) {
                    try {
                        SET_PROFILE_METHOD = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                        SET_PROFILE_METHOD.setAccessible(true);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    INITIALIZED = true;
                }
                if (SET_PROFILE_METHOD != null) {
                    SET_PROFILE_METHOD.invoke((Object)meta, profile);
                } else {
                    if (PROFILE_FIELD == null) {
                        PROFILE_FIELD = meta.getClass().getDeclaredField("profile");
                        PROFILE_FIELD.setAccessible(true);
                    }
                    PROFILE_FIELD.set(meta, profile);
                }
            }
            itemStack.setItemMeta(meta);
            if (Version.before(13)) {
                itemStack.setDurability((short)SkullType.PLAYER.ordinal());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setSkullTextureFromURL(@NonNull ItemStack itemStack, @NonNull String url) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        SkullUtils.setSkullTexture(itemStack, SkullUtils.getTextureFromURL(url));
    }

    @Nullable
    public static String getSkullOwner(@NonNull ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof SkullMeta) {
            return ((SkullMeta)meta).getOwner();
        }
        return null;
    }

    public static void setSkullOwner(@NonNull ItemStack itemStack, @NonNull String owner) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof SkullMeta) {
            ((SkullMeta)meta).setOwner(owner);
            itemStack.setItemMeta(meta);
            if (Version.before(13)) {
                itemStack.setDurability((short)SkullType.PLAYER.ordinal());
            }
        }
    }

    @Nullable
    public static String getTextureFromURL(String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
        String toEncode = "{\"textures\":{\"SKIN\":{\"url\":\"" + uri.toString() + "\"}}}";
        return Base64.getEncoder().encodeToString(toEncode.getBytes());
    }

    private SkullUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        INITIALIZED = false;
    }
}

