/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.file;

import eu.decentsoftware.holograms.api.utils.Common;
import java.io.File;
import javax.annotation.Nonnull;

public final class FileUtils {
    @Nonnull
    public static String[] getFileNames(String path) {
        return FileUtils.getFileNames(path, null);
    }

    @Nonnull
    public static String[] getFileNames(String path, String regex) {
        return FileUtils.getFileNames(path, regex, false);
    }

    public static String[] getFileNames(String path, String regex, boolean createDir) {
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            return dir.list((dir1, name) -> regex == null || regex.trim().isEmpty() || name.matches(regex));
        }
        if (createDir && dir.mkdirs()) {
            Common.log("Created directory %s", path);
        }
        return new String[0];
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

