/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.config;

import eu.decentsoftware.holograms.api.utils.config.FileConfig;

public class ConfigValue<T> {
    protected final FileConfig config;
    protected final boolean setDefault;
    protected final String path;
    protected final T defaultValue;
    protected T value;

    public ConfigValue(FileConfig config, boolean setDefault, String path, T defaultValue) {
        this.config = config;
        this.setDefault = setDefault;
        this.path = path;
        this.defaultValue = defaultValue;
        this.updateValue();
    }

    public ConfigValue(FileConfig config, String path, T defaultValue) {
        this(config, true, path, defaultValue);
    }

    public void updateValue() {
        if (!this.config.contains(this.path)) {
            this.value = this.defaultValue;
            if (this.setDefault) {
                this.config.set(this.path, this.defaultValue);
                this.config.saveData();
                this.config.reload();
            }
        } else {
            Object o = this.config.get(this.path);
            try {
                this.value = o;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.value = this.defaultValue;
            }
        }
    }

    public FileConfig getConfig() {
        return this.config;
    }

    public String getPath() {
        return this.path;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        return this.value == null ? this.defaultValue : this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }
}

