/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.utils.config;

import eu.decentsoftware.holograms.api.utils.config.Key;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CFG {
    @Nullable
    public static YamlConfiguration load(@NotNull JavaPlugin plugin, @NotNull Object object, @NotNull File file) {
        try {
            YamlConfiguration config;
            if (!file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
                return null;
            }
            if (!file.exists()) {
                InputStream is = plugin.getResource(file.getName());
                if (is != null) {
                    InputStreamReader isr = new InputStreamReader(is);
                    YamlConfiguration config2 = YamlConfiguration.loadConfiguration((Reader)isr);
                    config2.save(file);
                    CFG.loadFromConfigurationToObject(object, (ConfigurationSection)config2);
                    return config2;
                }
                config = (YamlConfiguration)CFG.saveIntoConfigurationFromObject(object);
                config.save(file);
            } else {
                config = YamlConfiguration.loadConfiguration((File)file);
                CFG.loadFromConfigurationToObject(object, (ConfigurationSection)config);
            }
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static ConfigurationSection saveIntoConfigurationFromObject(@NotNull Object object) {
        return CFG.saveIntoConfigurationFromObject(object, (ConfigurationSection)new YamlConfiguration());
    }

    @NotNull
    public static ConfigurationSection saveIntoConfigurationFromObject(@NotNull Object object, @NotNull ConfigurationSection config) {
        boolean stat = object instanceof Class;
        Class<?> clazz = stat ? (Class<?>)object : object.getClass();
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Key.class)) continue;
            f.setAccessible(true);
            Key configValue = f.getAnnotation(Key.class);
            String key = configValue.value();
            try {
                Object newValue = Modifier.isStatic(f.getModifiers()) ? f.get(null) : (!stat ? f.get(object) : null);
                Object currentValue = config.get(key);
                if (currentValue != null && currentValue.equals(newValue)) continue;
                config.set(key, newValue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return config;
    }

    public static void loadFromConfigurationToObject(@NotNull Object object, @NotNull ConfigurationSection config) {
        boolean stat = object instanceof Class;
        Class<?> clazz = stat ? (Class<?>)object : object.getClass();
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Key.class)) continue;
            f.setAccessible(true);
            Key configValue = f.getAnnotation(Key.class);
            String key = configValue.value();
            double min = configValue.min();
            double max = configValue.max();
            try {
                Object o = config.get(key);
                if (o == null) continue;
                if (o instanceof Number) {
                    int numberValue;
                    Number number = (Number)o;
                    Class<Number> fType = f.getType();
                    if (fType.isAssignableFrom(Integer.TYPE)) {
                        numberValue = number.intValue();
                        CFG.setFieldValue(f, object, (int)Math.min(Math.max((double)numberValue, min), max));
                        continue;
                    }
                    if (fType.isAssignableFrom(Float.TYPE)) {
                        float numberValue2 = number.floatValue();
                        CFG.setFieldValue(f, object, Float.valueOf((float)Math.min(Math.max((double)numberValue2, min), max)));
                        continue;
                    }
                    if (fType.isAssignableFrom(Double.TYPE)) {
                        double numberValue3 = number.doubleValue();
                        CFG.setFieldValue(f, object, Math.min(Math.max(numberValue3, min), max));
                        continue;
                    }
                    if (fType.isAssignableFrom(Short.TYPE)) {
                        numberValue = number.shortValue();
                        CFG.setFieldValue(f, object, (short)Math.min(Math.max((double)numberValue, min), max));
                        continue;
                    }
                    if (!fType.isAssignableFrom(Byte.TYPE)) continue;
                    numberValue = number.byteValue();
                    CFG.setFieldValue(f, object, (byte)Math.min(Math.max((double)numberValue, min), max));
                    continue;
                }
                CFG.setFieldValue(f, object, o);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void setFieldValue(@NotNull Field f, Object parent, Object o) throws IllegalAccessException {
        if (Modifier.isStatic(f.getModifiers())) {
            f.set(null, o);
        } else if (!(parent instanceof Class)) {
            f.set(parent, o);
        }
    }

    private CFG() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

