/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.nms;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.nms.NMS;
import eu.decentsoftware.holograms.api.nms.PacketHandler__Custom;
import eu.decentsoftware.holograms.api.nms.PacketHandler__ProtocolLib;
import eu.decentsoftware.holograms.api.utils.Common;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListener {
    private static final NMS nms = NMS.getInstance();
    private static final String IDENTIFIER = "DecentHolograms";
    private boolean usingProtocolLib = false;

    public PacketListener() {
        if (Common.isPluginEnabled("ProtocolLib")) {
            new PacketHandler__ProtocolLib();
            this.usingProtocolLib = true;
            Common.log("Using ProtocolLib for packet listening.");
        } else {
            this.hookAll();
        }
    }

    public void destroy() {
        if (this.usingProtocolLib) {
            if (Common.isPluginEnabled("ProtocolLib")) {
                ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
                protocolManager.removePacketListeners((Plugin)DecentHologramsAPI.get().getPlugin());
                this.usingProtocolLib = false;
            }
        } else {
            this.unhookAll();
        }
    }

    public boolean hook(Player player) {
        if (this.usingProtocolLib) {
            return true;
        }
        try {
            ChannelPipeline pipeline = nms.getPipeline(player);
            if (pipeline.get(IDENTIFIER) == null) {
                PacketHandler__Custom packetHandler = new PacketHandler__Custom(player);
                pipeline.addBefore("packet_handler", IDENTIFIER, (ChannelHandler)packetHandler);
            }
            return true;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void hookAll() {
        if (!this.usingProtocolLib) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.hook(player);
            }
        }
    }

    public boolean unhook(Player player) {
        if (this.usingProtocolLib) {
            return true;
        }
        try {
            ChannelPipeline pipeline = NMS.getInstance().getPipeline(player);
            if (pipeline.get(IDENTIFIER) != null) {
                pipeline.remove(IDENTIFIER);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void unhookAll() {
        if (!this.usingProtocolLib) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.unhook(player);
            }
        }
    }
}

