/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.holograms.offset;

import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramLine;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import eu.decentsoftware.holograms.api.holograms.offset.OffsetCalculator;
import eu.decentsoftware.holograms.api.utils.tick.Ticked;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class OffsetListener
extends Ticked
implements Listener {
    private final Map<UUID, Float> lastYaws = new ConcurrentHashMap<UUID, Float>();
    private final Map<UUID, Float> lastYawsTemp = new ConcurrentHashMap<UUID, Float>();

    public OffsetListener() {
        super(2L);
    }

    public void destroy() {
        this.unregister();
        this.lastYawsTemp.clear();
        this.lastYaws.clear();
    }

    @Override
    public void tick() {
        for (Hologram hologram : Hologram.getCachedHolograms()) {
            if (!hologram.isEnabled() || !hologram.isAlwaysFacePlayer()) continue;
            for (Player player : hologram.getViewerPlayers()) {
                float lastYaw;
                UUID uuid = player.getUniqueId();
                Location l = player.getLocation();
                float yaw = l.getYaw();
                if (this.lastYaws.containsKey(uuid) && Math.abs(yaw - (lastYaw = this.lastYaws.get(uuid).floatValue())) < 1.0f) continue;
                this.updateOffsets(player, hologram);
                this.lastYawsTemp.put(uuid, Float.valueOf(yaw));
            }
        }
        this.lastYaws.putAll(this.lastYawsTemp);
        this.lastYawsTemp.clear();
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        this.lastYaws.remove(player.getUniqueId());
    }

    public void updateOffsets(Player player, Hologram hologram) {
        Location playerLoc = player.getLocation();
        Location holoLoc = hologram.getLocation();
        HologramPage page = hologram.getPage(player);
        if (page == null || !page.isAlwaysFacePlayer() || !page.hasOffsets()) {
            return;
        }
        for (HologramLine line : page.getLines()) {
            if (line.getOffsetX() == 0.0 && line.getOffsetZ() == 0.0) continue;
            Location prevLocation = line.getLocation();
            OffsetCalculator.Loc2D result = OffsetCalculator.calculateOffSet(new OffsetCalculator.Loc2D(playerLoc.getX(), playerLoc.getZ()), new OffsetCalculator.Loc2D(line.getOffsetX(), line.getOffsetZ()), new OffsetCalculator.Loc2D(holoLoc.getX(), holoLoc.getZ()));
            Location finalOffsetLoc = new Location(holoLoc.getWorld(), result.getX(), line.getLocation().getY(), result.getZ());
            finalOffsetLoc.setYaw(prevLocation.getYaw());
            line.setLocation(finalOffsetLoc);
            line.updateLocation(false, player);
            line.setLocation(prevLocation);
        }
    }
}

