/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.holograms;

import com.google.common.collect.ImmutableList;
import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.Settings;
import eu.decentsoftware.holograms.api.actions.Action;
import eu.decentsoftware.holograms.api.actions.ClickType;
import eu.decentsoftware.holograms.api.holograms.DisableCause;
import eu.decentsoftware.holograms.api.holograms.HologramLine;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import eu.decentsoftware.holograms.api.holograms.enums.EnumFlag;
import eu.decentsoftware.holograms.api.holograms.objects.UpdatingHologramObject;
import eu.decentsoftware.holograms.api.nms.NMS;
import eu.decentsoftware.holograms.api.utils.collection.DList;
import eu.decentsoftware.holograms.api.utils.config.FileConfig;
import eu.decentsoftware.holograms.api.utils.event.EventFactory;
import eu.decentsoftware.holograms.api.utils.exception.LocationParseException;
import eu.decentsoftware.holograms.api.utils.location.LocationUtils;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import eu.decentsoftware.holograms.api.utils.scheduler.S;
import eu.decentsoftware.holograms.api.utils.tick.ITicked;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Hologram
extends UpdatingHologramObject
implements ITicked {
    private static final DecentHolograms DECENT_HOLOGRAMS = DecentHologramsAPI.get();
    @NonNull
    private static final Map<String, Hologram> CACHED_HOLOGRAMS = new ConcurrentHashMap<String, Hologram>();
    @NonNull
    protected final String name;
    protected boolean saveToFile;
    @Nullable
    protected final FileConfig config;
    @NonNull
    protected final Map<UUID, Integer> viewerPages = new ConcurrentHashMap<UUID, Integer>();
    @NonNull
    protected final Set<UUID> hidePlayers = Collections.synchronizedSet(new HashSet());
    @NonNull
    protected final Set<UUID> showPlayers = Collections.synchronizedSet(new HashSet());
    protected boolean defaultVisibleState = true;
    @NonNull
    protected final DList<HologramPage> pages = new DList();
    protected boolean downOrigin = Settings.DEFAULT_DOWN_ORIGIN;
    protected boolean alwaysFacePlayer = false;
    @NonNull
    private final AtomicInteger tickCounter;

    public static Hologram getCachedHologram(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return CACHED_HOLOGRAMS.get(name);
    }

    @NonNull
    @Contract(pure=true)
    public static Set<String> getCachedHologramNames() {
        return CACHED_HOLOGRAMS.keySet();
    }

    @NonNull
    @Contract(pure=true)
    public static Collection<Hologram> getCachedHolograms() {
        return CACHED_HOLOGRAMS.values();
    }

    @Nullable
    public static Hologram fromFile(@NotNull String fileName) throws LocationParseException, IllegalArgumentException {
        FileConfig config = new FileConfig(DECENT_HOLOGRAMS.getPlugin(), "holograms/" + fileName);
        String name = fileName.toLowerCase().startsWith("hologram_") && fileName.length() > "hologram_".length() ? fileName.substring("hologram_".length(), fileName.length() - 4) : fileName.substring(0, fileName.length() - 4);
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Hologram name cannot be null or empty.");
        }
        if (Hologram.getCachedHologramNames().contains(name)) {
            throw new IllegalArgumentException("Hologram with name '" + name + "' already exists.");
        }
        String locationString = config.getString("location");
        Location location = LocationUtils.asLocationE(locationString);
        boolean enabled = true;
        if (config.isBoolean("enabled")) {
            enabled = config.getBoolean("enabled");
        }
        Hologram hologram = new Hologram(name, location, config, enabled);
        if (config.isString("permission")) {
            hologram.setPermission(config.getString("permission"));
        }
        hologram.setDisplayRange(config.getInt("display-range", Settings.DEFAULT_DISPLAY_RANGE));
        hologram.setUpdateRange(config.getInt("update-range", Settings.DEFAULT_UPDATE_RANGE));
        hologram.setUpdateInterval(config.getInt("update-interval", Settings.DEFAULT_UPDATE_INTERVAL));
        hologram.addFlags((EnumFlag[])config.getStringList("flags").stream().map(EnumFlag::valueOf).toArray(EnumFlag[]::new));
        if (config.isBoolean("down-origin")) {
            hologram.setDownOrigin(config.getBoolean("down-origin", Settings.DEFAULT_DOWN_ORIGIN));
        }
        if (!config.contains("pages") && config.contains("lines")) {
            HologramPage page = hologram.getPage(0);
            Set keysLines = config.getConfigurationSection("lines").getKeys(false);
            for (int j = 1; j <= keysLines.size(); ++j) {
                String path = "lines." + j;
                HologramLine line = HologramLine.fromFile(config.getConfigurationSection(path), page, page.getNextLineLocation());
                page.addLine(line);
            }
            config.set("lines", null);
            hologram.save();
            return hologram;
        }
        boolean firstPage = true;
        for (Map map : config.getMapList("pages")) {
            HologramPage page;
            if (firstPage) {
                page = hologram.getPage(0);
                firstPage = false;
            } else {
                page = hologram.addPage();
            }
            if (map.containsKey("actions")) {
                Map actionsMap = (Map)map.get("actions");
                for (ClickType clickType : ClickType.values()) {
                    if (!actionsMap.containsKey(clickType.name())) continue;
                    List clickTypeActions = (List)actionsMap.get(clickType.name());
                    for (String clickTypeAction : clickTypeActions) {
                        try {
                            page.addAction(clickType, new Action(clickTypeAction));
                        }
                        catch (Exception e) {
                            DECENT_HOLOGRAMS.getPlugin().getLogger().warning(String.format("Failed to parse action '%s' for hologram '%s' at page %s! Skipping...", clickTypeAction, hologram.getName(), page.getIndex()));
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (!map.containsKey("lines")) continue;
            for (Map lineMap : (List)map.get("lines")) {
                Map values = null;
                try {
                    values = lineMap;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (values == null) continue;
                HologramLine line = HologramLine.fromMap(values, page, page.getNextLineLocation());
                page.addLine(line);
            }
        }
        hologram.setFacing((float)config.getDouble("facing", 0.0));
        return hologram;
    }

    public Hologram(@NonNull String name, @NonNull Location location) {
        this(name, location, true);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
    }

    public Hologram(@NonNull String name, @NonNull Location location, boolean saveToFile) {
        this(name, location, saveToFile ? new FileConfig(DECENT_HOLOGRAMS.getPlugin(), String.format("holograms/%s.yml", name)) : null);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
    }

    public Hologram(@NonNull String name, @NonNull Location location, @Nullable FileConfig config) {
        this(name, location, config, true);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
    }

    public Hologram(@NonNull String name, @NonNull Location location, @Nullable FileConfig config, boolean enabled) {
        super(location);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.name = name;
        this.config = config;
        this.enabled = enabled;
        this.saveToFile = this.config != null;
        this.tickCounter = new AtomicInteger();
        this.addPage();
        this.register();
        CACHED_HOLOGRAMS.put(this.name, this);
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public long getInterval() {
        return 1L;
    }

    @Override
    public void tick() {
        if (this.tickCounter.get() == this.getUpdateInterval()) {
            this.tickCounter.set(1);
            this.updateAll();
            return;
        }
        this.tickCounter.incrementAndGet();
        this.updateAnimationsAll();
    }

    public String toString() {
        return this.getClass().getName() + "{name=" + this.getName() + ", enabled=" + this.isEnabled() + "} " + super.toString();
    }

    @Override
    public void delete() {
        super.delete();
        if (this.config != null) {
            this.config.delete();
        }
    }

    @Override
    public void destroy() {
        this.disable(DisableCause.API);
        this.viewerPages.clear();
        DECENT_HOLOGRAMS.getHologramManager().removeHologram(this.getName());
        CACHED_HOLOGRAMS.remove(this.getName());
    }

    @Override
    public void enable() {
        super.enable();
        this.showAll();
        this.register();
    }

    @Override
    public void disable(@NonNull DisableCause cause) {
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        this.unregister();
        this.hideAll();
        super.disable(cause);
    }

    @Override
    public void setFacing(float facing) {
        float prev = this.facing;
        super.setFacing(facing);
        for (HologramPage page : this.pages) {
            page.getLines().forEach(line -> {
                if (line.getFacing() == prev) {
                    line.setFacing(facing);
                }
                page.realignLines();
            });
        }
    }

    @Override
    public void setLocation(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        super.setLocation(location);
        this.hideClickableEntitiesAll();
        this.showClickableEntitiesAll();
    }

    public int size() {
        return this.pages.size();
    }

    public boolean save() {
        if (this.saveToFile) {
            S.async(() -> {
                this.config.set("location", LocationUtils.asString(this.location, false));
                this.config.set("enabled", this.isEnabled());
                this.config.set("permission", this.permission == null || this.permission.isEmpty() ? null : this.permission);
                this.config.set("flags", this.flags.isEmpty() ? null : this.flags.stream().map(Enum::name).collect(Collectors.toList()));
                this.config.set("display-range", this.displayRange);
                this.config.set("update-range", this.updateRange);
                this.config.set("update-interval", this.updateInterval);
                this.config.set("facing", Float.valueOf(this.facing));
                this.config.set("down-origin", this.downOrigin);
                this.config.set("pages", this.pages.stream().map(HologramPage::serializeToMap).collect(Collectors.toList()));
                this.config.saveData();
                this.config.reload();
            });
        }
        return true;
    }

    public Hologram clone(@NonNull String name, @NonNull Location location, boolean temp) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        Hologram hologram = new Hologram(name, location.clone(), !temp);
        hologram.setDownOrigin(this.isDownOrigin());
        hologram.setPermission(this.getPermission());
        hologram.setFacing(this.getFacing());
        hologram.setDisplayRange(this.getDisplayRange());
        hologram.setUpdateRange(this.getUpdateRange());
        hologram.setUpdateInterval(this.getUpdateInterval());
        hologram.addFlags(this.getFlags().toArray(new EnumFlag[0]));
        hologram.setDefaultVisibleState(this.isDefaultVisibleState());
        hologram.showPlayers.addAll(this.showPlayers);
        hologram.hidePlayers.addAll(this.hidePlayers);
        for (int i = 0; i < this.size(); ++i) {
            HologramPage page = this.getPage(i);
            HologramPage clonePage = page.clone(hologram, i);
            if (hologram.pages.size() > i) {
                hologram.pages.set(i, clonePage);
                continue;
            }
            hologram.pages.add(clonePage);
        }
        return hologram;
    }

    public boolean onClick(@NonNull Player player, int entityId, @NonNull ClickType clickType) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (clickType == null) {
            throw new NullPointerException("clickType is marked non-null but is null");
        }
        if (this.hasFlag(EnumFlag.DISABLE_ACTIONS)) {
            return false;
        }
        HologramPage page = this.getPage(player);
        if (page != null && page.hasEntity(entityId) && EventFactory.handleHologramInteractEvent(player, this, page, clickType, entityId)) {
            page.executeActions(player, clickType);
            return true;
        }
        return false;
    }

    public void onQuit(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.hide(player);
        this.removeShowPlayer(player);
        this.removeHidePlayer(player);
        this.viewerPages.remove(player.getUniqueId());
    }

    public void setDefaultVisibleState(boolean state) {
        this.defaultVisibleState = state;
    }

    public boolean isVisibleState() {
        return this.defaultVisibleState;
    }

    public void setHidePlayer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        UUID uniqueId = player.getUniqueId();
        if (!this.hidePlayers.contains(uniqueId)) {
            this.hidePlayers.add(player.getUniqueId());
        }
    }

    public void removeHidePlayer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        UUID uniqueId = player.getUniqueId();
        this.hidePlayers.remove(uniqueId);
    }

    public boolean isHideState(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.hidePlayers.contains(player.getUniqueId());
    }

    public void setShowPlayer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        UUID uniqueId = player.getUniqueId();
        if (!this.showPlayers.contains(uniqueId)) {
            this.showPlayers.add(player.getUniqueId());
        }
    }

    public void removeShowPlayer(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        UUID uniqueId = player.getUniqueId();
        this.showPlayers.remove(uniqueId);
    }

    public boolean isShowState(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.showPlayers.contains(player.getUniqueId());
    }

    public boolean show(@NonNull Player player, int pageIndex) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (this.isDisabled() || this.isHideState(player) || !this.isDefaultVisibleState() && !this.isShowState(player)) {
            return false;
        }
        HologramPage page = this.getPage(pageIndex);
        if (page != null && page.size() > 0 && this.canShow(player) && this.isInDisplayRange(player)) {
            if (this.isVisible(player)) {
                this.hide(player);
            }
            if (Version.after(8)) {
                this.showPageTo(player, page, pageIndex);
            } else {
                S.sync(() -> this.showPageTo(player, page, pageIndex), 0L);
            }
            return true;
        }
        return false;
    }

    private void showPageTo(@NonNull Player player, @NonNull HologramPage page, int pageIndex) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        page.getLines().forEach(line -> line.show(player));
        this.viewerPages.put(player.getUniqueId(), pageIndex);
        this.viewers.add(player.getUniqueId());
        this.showClickableEntities(player);
    }

    public void showAll() {
        if (this.isEnabled()) {
            Bukkit.getOnlinePlayers().forEach(player -> this.show((Player)player, this.getPlayerPage((Player)player)));
        }
    }

    public void update(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (this.hasFlag(EnumFlag.DISABLE_UPDATING) || !this.isVisible(player) || !this.isInUpdateRange(player) || this.isHideState(player)) {
            return;
        }
        HologramPage page = this.getPage(player);
        if (page != null) {
            page.getLines().forEach(line -> line.update(player));
        }
    }

    public void updateAll() {
        if (this.isEnabled() && !this.hasFlag(EnumFlag.DISABLE_UPDATING)) {
            this.getViewerPlayers().forEach(this::update);
        }
    }

    public void updateAnimations(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (this.hasFlag(EnumFlag.DISABLE_ANIMATIONS) || !this.isVisible(player) || !this.isInUpdateRange(player) || this.isHideState(player)) {
            return;
        }
        HologramPage page = this.getPage(player);
        if (page != null) {
            page.getLines().forEach(line -> line.updateAnimations(player));
        }
    }

    public void updateAnimationsAll() {
        if (this.isEnabled() && !this.hasFlag(EnumFlag.DISABLE_ANIMATIONS)) {
            this.getViewerPlayers().forEach(this::updateAnimations);
        }
    }

    public void hide(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (this.isVisible(player)) {
            HologramPage page = this.getPage(player);
            if (page != null) {
                page.getLines().forEach(line -> line.hide(player));
                this.hideClickableEntities(player);
            }
            this.viewers.remove(player.getUniqueId());
        }
    }

    public void hideAll() {
        if (this.isEnabled()) {
            this.getViewerPlayers().forEach(this::hide);
        }
    }

    public void showClickableEntities(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        HologramPage page = this.getPage(player);
        if (page == null) {
            return;
        }
        NMS nms = NMS.getInstance();
        int amount = (int)(page.getHeight() / 2.0) + 1;
        Location location = this.getLocation().clone();
        location.setY((double)((int)(location.getY() - (this.isDownOrigin() ? 0.0 : page.getHeight()))) + 0.5);
        for (int i = 0; i < amount; ++i) {
            int id = page.getClickableEntityId(i);
            nms.showFakeEntityArmorStand(player, location, id, true, false, true);
            location.add(0.0, 1.8, 0.0);
        }
    }

    public void showClickableEntitiesAll() {
        if (this.isEnabled()) {
            this.getViewerPlayers().forEach(this::showClickableEntities);
        }
    }

    public void hideClickableEntities(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        HologramPage page = this.getPage(player);
        if (page == null) {
            return;
        }
        NMS nms = NMS.getInstance();
        page.getClickableEntityIds().forEach(id -> nms.hideFakeEntities(player, (int)id));
    }

    public void hideClickableEntitiesAll() {
        if (this.isEnabled()) {
            this.getViewerPlayers().forEach(this::hideClickableEntities);
        }
    }

    public boolean isInDisplayRange(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        try {
            if (player != null && player.getWorld().equals(this.location.getWorld())) {
                return player.getLocation().distanceSquared(this.location) <= (double)(this.displayRange * this.displayRange);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isInUpdateRange(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        try {
            if (player != null && player.getWorld().equals(this.location.getWorld())) {
                return player.getLocation().distanceSquared(this.location) <= (double)(this.updateRange * this.updateRange);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setDownOrigin(boolean downOrigin) {
        this.downOrigin = downOrigin;
        this.hideClickableEntitiesAll();
        this.showClickableEntitiesAll();
    }

    public int getPlayerPage(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.viewerPages.getOrDefault(player.getUniqueId(), 0);
    }

    public Set<Player> getViewerPlayers(int pageIndex) {
        HashSet<Player> players = new HashSet<Player>();
        this.viewerPages.forEach((uuid, integer) -> {
            if (integer == pageIndex) {
                players.add(Bukkit.getPlayer((UUID)uuid));
            }
        });
        return players;
    }

    public void realignLines() {
        for (HologramPage page : this.pages) {
            page.realignLines();
        }
    }

    public HologramPage addPage() {
        HologramPage page = new HologramPage(this, this.pages.size());
        this.pages.add(page);
        return page;
    }

    public HologramPage insertPage(int index) {
        if (index < 0 || index > this.size()) {
            return null;
        }
        HologramPage page = new HologramPage(this, index);
        this.pages.add(index, page);
        this.pages.stream().skip(index).forEach(p -> p.setIndex(p.getIndex() + 1));
        this.viewerPages.replaceAll((uuid, integer) -> {
            if (integer > index) {
                return integer + 1;
            }
            return integer;
        });
        return page;
    }

    public HologramPage getPage(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return (HologramPage)this.pages.get(index);
    }

    public HologramPage getPage(@NonNull Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (this.isVisible(player)) {
            return this.getPage(this.getPlayerPage(player));
        }
        return null;
    }

    public HologramPage removePage(int index) {
        if (index < 0 || index > this.size()) {
            return null;
        }
        HologramPage page = (HologramPage)this.pages.remove(index);
        page.getLines().forEach(rec$ -> ((HologramLine)rec$).hide(new Player[0]));
        for (int i = 0; i < this.pages.size(); ++i) {
            ((HologramPage)this.pages.get(i)).setIndex(i);
        }
        if (this.pages.size() > 0) {
            for (UUID uuid : this.viewerPages.keySet()) {
                int currentPage = this.viewerPages.get(uuid);
                if (currentPage == index) {
                    this.show(Bukkit.getPlayer((UUID)uuid), 0);
                    continue;
                }
                if (currentPage <= index) continue;
                this.viewerPages.put(uuid, currentPage - 1);
            }
        }
        return page;
    }

    public boolean swapPages(int index1, int index2) {
        if (index1 == index2 || index1 < 0 || index1 >= this.size() || index2 < 0 || index2 >= this.size()) {
            return false;
        }
        Collections.swap(this.pages, index1, index2);
        HologramPage page1 = this.getPage(index1);
        HologramPage page2 = this.getPage(index2);
        int i = page1.getIndex();
        page1.setIndex(page2.getIndex());
        page2.setIndex(i);
        Set<Player> viewers1 = this.getViewerPlayers(index1);
        Set<Player> viewers2 = this.getViewerPlayers(index2);
        viewers1.forEach(player -> this.show((Player)player, index2));
        viewers2.forEach(player -> this.show((Player)player, index1));
        return true;
    }

    public List<HologramPage> getPages() {
        return ImmutableList.copyOf(this.pages);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean isSaveToFile() {
        return this.saveToFile;
    }

    @Nullable
    public FileConfig getConfig() {
        return this.config;
    }

    @NonNull
    public Map<UUID, Integer> getViewerPages() {
        return this.viewerPages;
    }

    @NonNull
    public Set<UUID> getHidePlayers() {
        return this.hidePlayers;
    }

    @NonNull
    public Set<UUID> getShowPlayers() {
        return this.showPlayers;
    }

    public boolean isDefaultVisibleState() {
        return this.defaultVisibleState;
    }

    public boolean isDownOrigin() {
        return this.downOrigin;
    }

    public boolean isAlwaysFacePlayer() {
        return this.alwaysFacePlayer;
    }

    @NonNull
    public AtomicInteger getTickCounter() {
        return this.tickCounter;
    }

    public void setSaveToFile(boolean saveToFile) {
        this.saveToFile = saveToFile;
    }

    public void setAlwaysFacePlayer(boolean alwaysFacePlayer) {
        this.alwaysFacePlayer = alwaysFacePlayer;
    }
}

