/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.commands;

import com.google.common.collect.Lists;
import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.actions.ActionType;
import eu.decentsoftware.holograms.api.actions.ClickType;
import eu.decentsoftware.holograms.api.commands.CommandValidator;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.command.CommandSender;

@FunctionalInterface
public interface TabCompleteHandler {
    public static final DecentHolograms PLUGIN = DecentHologramsAPI.get();
    public static final TabCompleteHandler HOLOGRAM_NAMES = (sender, args) -> {
        if (args.length == 1) {
            return TabCompleteHandler.getPartialMatches(args[0], PLUGIN.getHologramManager().getHologramNames());
        }
        return null;
    };
    public static final TabCompleteHandler HOLOGRAM_PAGES = (sender, args) -> {
        Hologram hologram;
        if (args.length == 1) {
            return TabCompleteHandler.getPartialMatches(args[0], PLUGIN.getHologramManager().getHologramNames());
        }
        if (args.length == 2 && (hologram = PLUGIN.getHologramManager().getHologram(args[0])) != null) {
            return TabCompleteHandler.getPartialMatches(args[1], IntStream.rangeClosed(1, hologram.size()).boxed().map(String::valueOf).collect(Collectors.toList()));
        }
        return null;
    };
    public static final TabCompleteHandler HOLOGRAM_PAGES_CLICK_TYPES = (sender, args) -> {
        if (args.length == 1) {
            return TabCompleteHandler.getPartialMatches(args[0], PLUGIN.getHologramManager().getHologramNames());
        }
        if (args.length == 2) {
            Hologram hologram = PLUGIN.getHologramManager().getHologram(args[0]);
            if (hologram != null) {
                return TabCompleteHandler.getPartialMatches(args[1], IntStream.rangeClosed(1, hologram.size()).boxed().map(String::valueOf).collect(Collectors.toList()));
            }
        } else if (args.length == 3) {
            return TabCompleteHandler.getPartialMatches(args[2], Arrays.stream(ClickType.values()).map(Enum::name).collect(Collectors.toList()));
        }
        return null;
    };
    public static final TabCompleteHandler HOLOGRAM_PAGES_ACTIONS = (sender, args) -> {
        if (args.length == 1) {
            return TabCompleteHandler.getPartialMatches(args[0], PLUGIN.getHologramManager().getHologramNames());
        }
        if (args.length == 2) {
            Hologram hologram = PLUGIN.getHologramManager().getHologram(args[0]);
            if (hologram != null) {
                return TabCompleteHandler.getPartialMatches(args[1], IntStream.rangeClosed(1, hologram.size()).boxed().map(String::valueOf).collect(Collectors.toList()));
            }
        } else {
            if (args.length == 3) {
                return TabCompleteHandler.getPartialMatches(args[2], Arrays.stream(ClickType.values()).map(Enum::name).collect(Collectors.toList()));
            }
            if (args.length == 4) {
                return TabCompleteHandler.getPartialMatches(args[2], ActionType.getActionTypes().stream().map(ActionType::getName).collect(Collectors.toList()));
            }
        }
        return null;
    };
    public static final TabCompleteHandler HOLOGRAM_PAGES_ACTION_INDEXES = (sender, args) -> {
        ArrayList matches = Lists.newArrayList();
        if (args.length == 1) {
            return TabCompleteHandler.getPartialMatches(args[0], PLUGIN.getHologramManager().getHologramNames());
        }
        if (args.length == 2) {
            Hologram hologram = PLUGIN.getHologramManager().getHologram(args[0]);
            if (hologram != null) {
                return TabCompleteHandler.getPartialMatches(args[1], IntStream.rangeClosed(1, hologram.size()).boxed().map(String::valueOf).collect(Collectors.toList()));
            }
        } else {
            ClickType clickType;
            HologramPage page;
            Hologram hologram;
            if (args.length == 3) {
                return TabCompleteHandler.getPartialMatches(args[2], Arrays.stream(ClickType.values()).map(Enum::name).collect(Collectors.toList()));
            }
            if (args.length == 4 && (hologram = PLUGIN.getHologramManager().getHologram(args[0])) != null && (page = hologram.getPage(CommandValidator.getInteger(args[1]) - 1)) != null && (clickType = ClickType.fromString(args[2])) != null) {
                return TabCompleteHandler.getPartialMatches(args[3], IntStream.rangeClosed(1, page.getActions(clickType).size()).boxed().map(String::valueOf).collect(Collectors.toList()));
            }
        }
        return matches;
    };

    public static List<String> getPartialMatches(String token, String ... originals) {
        return TabCompleteHandler.getPartialMatches(token, Arrays.asList(originals));
    }

    public static List<String> getPartialMatches(String token, Collection<String> originals) {
        if (originals == null) {
            return Collections.emptyList();
        }
        if (token == null || token.isEmpty()) {
            return new ArrayList<String>(originals);
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (String str : originals) {
            if (str.length() < token.length() || !str.regionMatches(true, 0, token, 0, token.length())) continue;
            matches.add(str);
        }
        return matches;
    }

    public List<String> handleTabComplete(CommandSender var1, String[] var2);
}

