/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api.animations;

import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.animations.TextAnimation;
import eu.decentsoftware.holograms.api.animations.custom.CustomTextAnimation;
import eu.decentsoftware.holograms.api.animations.text.BurnAnimation;
import eu.decentsoftware.holograms.api.animations.text.ColorsAnimation;
import eu.decentsoftware.holograms.api.animations.text.ScrollAnimation;
import eu.decentsoftware.holograms.api.animations.text.TypewriterAnimation;
import eu.decentsoftware.holograms.api.animations.text.WaveAnimation;
import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.file.FileUtils;
import eu.decentsoftware.holograms.api.utils.scheduler.S;
import eu.decentsoftware.holograms.api.utils.tick.Ticked;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;

public class AnimationManager
extends Ticked {
    private static final DecentHolograms DECENT_HOLOGRAMS = DecentHologramsAPI.get();
    private static final Pattern ANIMATION_PATTERN = Pattern.compile("[<{]#?ANIM:(\\w+)(:\\S+)?[}>](.*?)[<{]/#?ANIM[}>]");
    private final Map<String, TextAnimation> animationMap = new HashMap<String, TextAnimation>();
    private final AtomicLong step = new AtomicLong(0L);

    public AnimationManager() {
        super(1L);
        this.reload();
    }

    @Override
    public void tick() {
        this.step.incrementAndGet();
    }

    public void destroy() {
        this.unregister();
        this.animationMap.clear();
    }

    public void reload() {
        this.animationMap.clear();
        this.registerAnimation(new TypewriterAnimation());
        this.registerAnimation(new WaveAnimation());
        this.registerAnimation(new BurnAnimation());
        this.registerAnimation(new ScrollAnimation());
        this.registerAnimation(new ColorsAnimation());
        this.step.set(0L);
        this.register();
        S.async(this::loadCustomAnimations);
    }

    public long getStep() {
        return this.step.get();
    }

    @NonNull
    public String parseTextAnimations(@NonNull String string) {
        TextAnimation animation;
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        Matcher matcher = ANIMATION_PATTERN.matcher(string);
        while (matcher.find()) {
            String animationName = matcher.group(1);
            String args = matcher.group(2);
            String text = matcher.group(3);
            TextAnimation animation2 = this.getAnimation(animationName);
            if (animation2 == null) continue;
            string = string.replace(matcher.group(), animation2.animate(text, this.getStep(), args == null ? null : args.substring(1).split(",")));
        }
        if (string.contains("&u") && (animation = this.getAnimation("colors")) != null) {
            string = string.replace("&u", animation.animate("", this.getStep(), new String[0]));
        }
        return string;
    }

    public boolean containsAnimations(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        Matcher matcher = ANIMATION_PATTERN.matcher(string);
        return matcher.find() || string.contains("&u");
    }

    public TextAnimation registerAnimation(@NonNull String name, @NonNull TextAnimation animation) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (animation == null) {
            throw new NullPointerException("animation is marked non-null but is null");
        }
        return this.animationMap.put(name, animation);
    }

    public TextAnimation registerAnimation(@NonNull TextAnimation animation) {
        if (animation == null) {
            throw new NullPointerException("animation is marked non-null but is null");
        }
        return this.animationMap.put(animation.getName(), animation);
    }

    public TextAnimation unregisterAnimation(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.animationMap.remove(name);
    }

    public TextAnimation getAnimation(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.animationMap.get(name);
    }

    private void loadCustomAnimations() {
        String[] fileNames = FileUtils.getFileNames(DECENT_HOLOGRAMS.getDataFolder() + "/animations", "[a-zA-Z0-9_-]+\\.yml", true);
        if (fileNames == null || fileNames.length == 0) {
            return;
        }
        int counter = 0;
        Common.log("Loading animations...");
        for (String fileName : fileNames) {
            try {
                CustomTextAnimation animation = CustomTextAnimation.fromFile(fileName);
                if (animation == null) continue;
                this.registerAnimation(animation);
                ++counter;
            }
            catch (Exception e) {
                Common.log(Level.WARNING, "Failed to load animation from file '%s'!", fileName);
                e.printStackTrace();
            }
        }
        Common.log("Loaded %d animations!", counter);
    }
}

