/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api;

import com.google.common.collect.ImmutableMap;
import eu.decentsoftware.holograms.api.DecentHolograms;
import eu.decentsoftware.holograms.api.DecentHologramsAPI;
import eu.decentsoftware.holograms.api.utils.config.CFG;
import eu.decentsoftware.holograms.api.utils.config.FileConfig;
import eu.decentsoftware.holograms.api.utils.config.Key;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public final class Settings {
    private static final DecentHolograms DECENT_HOLOGRAMS = DecentHologramsAPI.get();
    private static final FileConfig CONFIG = new FileConfig(DECENT_HOLOGRAMS.getPlugin(), "config.yml");
    @Key(value="update-checker")
    public static boolean CHECK_FOR_UPDATES = true;
    @Key(value="click-cooldown", min=1.0, max=300.0)
    public static int CLICK_COOLDOWN = 5;
    @Key(value="default.text")
    public static String DEFAULT_TEXT = "Blank Line";
    @Key(value="defaults.down-origin")
    public static boolean DEFAULT_DOWN_ORIGIN = false;
    @Key(value="defaults.height.text", min=0.0, max=2.5)
    public static double DEFAULT_HEIGHT_TEXT = 0.3;
    @Key(value="defaults.height.icon", min=0.0, max=2.5)
    public static double DEFAULT_HEIGHT_ICON = 0.6;
    @Key(value="defaults.height.head", min=0.0, max=2.5)
    public static double DEFAULT_HEIGHT_HEAD = 0.75;
    @Key(value="defaults.height.smallhead", min=0.0, max=2.5)
    public static double DEFAULT_HEIGHT_SMALLHEAD = 0.6;
    @Key(value="defaults.display-range", min=1.0, max=48.0)
    public static int DEFAULT_DISPLAY_RANGE = 48;
    @Key(value="defaults.update-range", min=1.0, max=48.0)
    public static int DEFAULT_UPDATE_RANGE = 48;
    @Key(value="defaults.update-interval", min=1.0, max=1200.0)
    public static int DEFAULT_UPDATE_INTERVAL = 20;
    @Key(value="defaults.lru-cache-size", min=5.0, max=10000.0)
    public static int DEFAULT_LRU_CACHE_SIZE = 500;
    @Key(value="allow-placeholders-inside-animations")
    public static boolean ALLOW_PLACEHOLDERS_INSIDE_ANIMATIONS = false;
    public static Map<String, String> CUSTOM_REPLACEMENTS = ImmutableMap.builder().put((Object)"[x]", (Object)"\u2588").put((Object)"[X]", (Object)"\u2588").put((Object)"[/]", (Object)"\u258c").put((Object)"[,]", (Object)"\u2591").put((Object)"[,,]", (Object)"\u2592").put((Object)"[,,,]", (Object)"\u2593").put((Object)"[p]", (Object)"\u2022").put((Object)"[P]", (Object)"\u2022").put((Object)"[|]", (Object)"\u23b9").build();

    public static void reload() {
        CONFIG.reload();
        CFG.load(DECENT_HOLOGRAMS.getPlugin(), Settings.class, CONFIG.getFile());
        ConfigurationSection customReplacementsSection = CONFIG.getConfigurationSection("custom-replacements");
        if (customReplacementsSection != null) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            for (String key : customReplacementsSection.getKeys(false)) {
                if (!customReplacementsSection.isString(key)) continue;
                replacements.put(key, customReplacementsSection.getString(key));
            }
            CUSTOM_REPLACEMENTS = replacements;
        }
    }

    public static FileConfig getConfig() {
        return CONFIG;
    }

    private Settings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

