/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.util.permissions;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.util.permissions.DefaultPermissions;
import org.jetbrains.annotations.NotNull;

public final class PurpurPermissions {
    private static final String ROOT = "purpur";
    private static final String PREFIX = "purpur.";
    private static final Set<String> mobs = new HashSet<String>();

    @NotNull
    public static Permission registerPermissions() {
        Permission purpur = DefaultPermissions.registerPermission(ROOT, "Gives the user the ability to use all Purpur utilities and commands", PermissionDefault.FALSE);
        DefaultPermissions.registerPermission("purpur.enderchest.rows.six", "Gives the user six rows of enderchest space", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.enderchest.rows.five", "Gives the user five rows of enderchest space", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.enderchest.rows.four", "Gives the user four rows of enderchest space", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.enderchest.rows.three", "Gives the user three rows of enderchest space", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.enderchest.rows.two", "Gives the user two rows of enderchest space", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.enderchest.rows.one", "Gives the user one row of enderchest space", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.debug.f3n", "Allows the user to use F3+N keybind to swap gamemodes", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.joinfullserver", "Allows the user to join a full server", PermissionDefault.OP, purpur);
        DefaultPermissions.registerPermission("purpur.drop.spawners", "Allows the user to drop spawner cage when broken with diamond pickaxe with silk touch", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.place.spawners", "Allows the user to place spawner cage in the world", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.mending_shift_click", "Allows the user to use shift-right-click to mend items", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.inventory_totem", "Uses a totem from anywhere in the user's inventory on death", PermissionDefault.FALSE, purpur);
        Permission anvil = DefaultPermissions.registerPermission("purpur.anvil", "Allows the user to use all anvil color and format abilities", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.anvil.color", "Allows the user to use color codes in an anvil", PermissionDefault.FALSE, anvil);
        DefaultPermissions.registerPermission("purpur.anvil.minimessage", "Allows the user to use minimessage tags in an anvil", PermissionDefault.FALSE, anvil);
        DefaultPermissions.registerPermission("purpur.anvil.remove_italics", "Allows the user to remove italics in an anvil", PermissionDefault.FALSE, anvil);
        DefaultPermissions.registerPermission("purpur.anvil.format", "Allows the user to use format codes in an anvil", PermissionDefault.FALSE, anvil);
        anvil.recalculatePermissibles();
        Permission book = DefaultPermissions.registerPermission("purpur.book", "Allows the user to use color codes on books", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.book.color.edit", "Allows the user to use color codes on books when editing", PermissionDefault.FALSE, book);
        DefaultPermissions.registerPermission("purpur.book.color.sign", "Allows the user to use color codes on books when signing", PermissionDefault.FALSE, book);
        book.recalculatePermissibles();
        Permission sign = DefaultPermissions.registerPermission("purpur.sign", "Allows the user to use all sign abilities", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("purpur.sign.edit", "Allows the user to click signs to open sign editor", PermissionDefault.FALSE, sign);
        DefaultPermissions.registerPermission("purpur.sign.color", "Allows the user to use color codes on signs", PermissionDefault.FALSE, sign);
        DefaultPermissions.registerPermission("purpur.sign.style", "Allows the user to use style codes on signs", PermissionDefault.FALSE, sign);
        DefaultPermissions.registerPermission("purpur.sign.magic", "Allows the user to use magic/obfuscate code on signs", PermissionDefault.FALSE, sign);
        sign.recalculatePermissibles();
        Permission ride = DefaultPermissions.registerPermission("allow.ride", "Allows the user to ride all mobs", PermissionDefault.FALSE, purpur);
        for (String string : mobs) {
            DefaultPermissions.registerPermission("allow.ride." + string, "Allows the user to ride " + string, PermissionDefault.FALSE, ride);
        }
        ride.recalculatePermissibles();
        Permission special = DefaultPermissions.registerPermission("allow.special", "Allows the user to use all mobs special abilities", PermissionDefault.FALSE, purpur);
        for (String mob : mobs) {
            DefaultPermissions.registerPermission("allow.special." + mob, "Allows the user to use " + mob + " special ability", PermissionDefault.FALSE, special);
        }
        special.recalculatePermissibles();
        Permission permission = DefaultPermissions.registerPermission("allow.powered", "Allows the user to toggle all mobs powered state", PermissionDefault.FALSE, purpur);
        DefaultPermissions.registerPermission("allow.powered.creeper", "Allows the user to toggle creeper powered state", PermissionDefault.FALSE, permission);
        permission.recalculatePermissibles();
        DefaultPermissions.registerPermission("purpur.portal.instant", "Allows the user to bypass portal wait time", PermissionDefault.FALSE, purpur);
        purpur.recalculatePermissibles();
        return purpur;
    }

    static {
        for (EntityType mob : EntityType.values()) {
            Class<? extends Entity> clazz = mob.getEntityClass();
            if (clazz == null || !Mob.class.isAssignableFrom(clazz)) continue;
            mobs.add(mob.getName());
        }
    }
}

