/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface InventoryView {
    public static final int OUTSIDE = -999;

    @NotNull
    public Inventory getTopInventory();

    @NotNull
    public Inventory getBottomInventory();

    @NotNull
    public HumanEntity getPlayer();

    @NotNull
    public InventoryType getType();

    public void setItem(int var1, @Nullable ItemStack var2);

    @Nullable
    public ItemStack getItem(int var1);

    public void setCursor(@Nullable ItemStack var1);

    @NotNull
    public ItemStack getCursor();

    @Nullable
    public Inventory getInventory(int var1);

    public int convertSlot(int var1);

    @NotNull
    public InventoryType.SlotType getSlotType(int var1);

    public void close();

    public int countSlots();

    public boolean setProperty(@NotNull Property var1, int var2);

    @NotNull
    default public Component title() {
        return LegacyComponentSerializer.legacySection().deserialize(this.getTitle());
    }

    @Deprecated
    @NotNull
    public String getTitle();

    @NotNull
    public String getOriginalTitle();

    public void setTitle(@NotNull String var1);

    @Deprecated(forRemoval=true, since="1.21")
    public static enum Property {
        BREW_TIME(0, InventoryType.BREWING),
        FUEL_TIME(1, InventoryType.BREWING),
        BURN_TIME(0, InventoryType.FURNACE),
        TICKS_FOR_CURRENT_FUEL(1, InventoryType.FURNACE),
        COOK_TIME(2, InventoryType.FURNACE),
        TICKS_FOR_CURRENT_SMELTING(3, InventoryType.FURNACE),
        ENCHANT_BUTTON1(0, InventoryType.ENCHANTING),
        ENCHANT_BUTTON2(1, InventoryType.ENCHANTING),
        ENCHANT_BUTTON3(2, InventoryType.ENCHANTING),
        ENCHANT_XP_SEED(3, InventoryType.ENCHANTING),
        ENCHANT_ID1(4, InventoryType.ENCHANTING),
        ENCHANT_ID2(5, InventoryType.ENCHANTING),
        ENCHANT_ID3(6, InventoryType.ENCHANTING),
        ENCHANT_LEVEL1(7, InventoryType.ENCHANTING),
        ENCHANT_LEVEL2(8, InventoryType.ENCHANTING),
        ENCHANT_LEVEL3(9, InventoryType.ENCHANTING),
        LEVELS(0, InventoryType.BEACON),
        PRIMARY_EFFECT(1, InventoryType.BEACON),
        SECONDARY_EFFECT(2, InventoryType.BEACON),
        REPAIR_COST(0, InventoryType.ANVIL),
        BOOK_PAGE(0, InventoryType.LECTERN);

        int id;
        InventoryType style;

        private Property(int id, InventoryType appliesTo) {
            this.id = id;
            this.style = appliesTo;
        }

        @NotNull
        public InventoryType getType() {
            return this.style;
        }

        @ApiStatus.Internal
        public int getId() {
            return this.id;
        }
    }
}

