/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.mariadb.jdbc.plugin.credential.system;

import com.craftaro.third_party.org.mariadb.jdbc.Configuration;
import com.craftaro.third_party.org.mariadb.jdbc.HostAddress;
import com.craftaro.third_party.org.mariadb.jdbc.plugin.Credential;
import com.craftaro.third_party.org.mariadb.jdbc.plugin.CredentialPlugin;

public class PropertiesCredentialPlugin
implements CredentialPlugin {
    private Configuration conf;
    private String userName;

    @Override
    public String type() {
        return "PROPERTY";
    }

    @Override
    public CredentialPlugin initialize(Configuration conf, String userName, HostAddress hostAddress) {
        this.conf = conf;
        this.userName = userName;
        return this;
    }

    @Override
    public Credential get() {
        String userKey = this.conf.nonMappedOptions().getProperty("userKey");
        String pwdKey = this.conf.nonMappedOptions().getProperty("pwdKey");
        String propUser = System.getProperty(userKey != null ? userKey : "mariadb.user");
        return new Credential(propUser == null ? this.userName : propUser, System.getProperty(pwdKey != null ? pwdKey : "mariadb.pwd"));
    }
}

