/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.mariadb.jdbc.plugin.codec;

import com.craftaro.third_party.org.mariadb.jdbc.MariaDbClob;
import com.craftaro.third_party.org.mariadb.jdbc.client.ColumnDecoder;
import com.craftaro.third_party.org.mariadb.jdbc.client.Context;
import com.craftaro.third_party.org.mariadb.jdbc.client.DataType;
import com.craftaro.third_party.org.mariadb.jdbc.client.ReadableByteBuf;
import com.craftaro.third_party.org.mariadb.jdbc.client.socket.Writer;
import com.craftaro.third_party.org.mariadb.jdbc.client.util.MutableInt;
import com.craftaro.third_party.org.mariadb.jdbc.plugin.Codec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.EnumSet;

public class ClobCodec
implements Codec<Clob> {
    public static final ClobCodec INSTANCE = new ClobCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.VARCHAR, new DataType[]{DataType.VARSTRING, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Clob.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isAssignableFrom(Clob.class) || type.isAssignableFrom(NClob.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Clob;
    }

    @Override
    public Clob decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return this.getClob(buf, length, column);
    }

    private Clob getClob(ReadableByteBuf buf, MutableInt length, ColumnDecoder column) throws SQLDataException {
        switch (column.getType()) {
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length.get());
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Clob", new Object[]{column.getType()}));
                }
            }
            case STRING: 
            case VARCHAR: 
            case VARSTRING: {
                MariaDbClob clob = new MariaDbClob(buf.buf(), buf.pos(), length.get());
                buf.skip(length.get());
                return clob;
            }
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Clob", new Object[]{column.getType()}));
    }

    @Override
    public Clob decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return this.getClob(buf, length, column);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException, SQLException {
        int len;
        Reader reader = ((Clob)value).getCharacterStream();
        char[] buf = new char[4096];
        encoder.writeByte(39);
        for (long remainingLen = maxLength == null ? Long.MAX_VALUE : maxLength; remainingLen > 0L && (len = reader.read(buf)) >= 0; remainingLen -= (long)len) {
            byte[] data = new String(buf, 0, (int)Math.min((long)len, remainingLen)).getBytes(StandardCharsets.UTF_8);
            encoder.writeBytesEscaped(data, data.length, (context.getServerStatus() & 0x200) != 0);
        }
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException, SQLException {
        int len;
        long remainingLen;
        Reader reader = ((Clob)value).getCharacterStream();
        byte[] clobBytes = new byte[4096];
        int pos = 0;
        char[] buf = new char[4096];
        long l = remainingLen = maxLength == null ? Long.MAX_VALUE : maxLength;
        while (remainingLen > 0L && (len = reader.read(buf)) > 0) {
            byte[] data = new String(buf, 0, (int)Math.min((long)len, remainingLen)).getBytes(StandardCharsets.UTF_8);
            if (clobBytes.length - pos < data.length) {
                byte[] newBlobBytes = new byte[clobBytes.length + 65536];
                System.arraycopy(clobBytes, 0, newBlobBytes, 0, pos);
                clobBytes = newBlobBytes;
            }
            System.arraycopy(data, 0, clobBytes, pos, data.length);
            pos += data.length;
            remainingLen -= (long)len;
        }
        encoder.writeLength(pos);
        encoder.writeBytes(clobBytes, 0, pos);
    }

    @Override
    public void encodeLongData(Writer encoder, Clob value, Long maxLength) throws IOException, SQLException {
        int len;
        long remainingLen;
        Reader reader = value.getCharacterStream();
        char[] buf = new char[4096];
        long l = remainingLen = maxLength == null ? Long.MAX_VALUE : maxLength;
        while (remainingLen > 0L && (len = reader.read(buf)) > 0) {
            byte[] data = new String(buf, 0, (int)Math.min((long)len, remainingLen)).getBytes(StandardCharsets.UTF_8);
            encoder.writeBytes(data, 0, data.length);
            remainingLen -= (long)len;
        }
    }

    @Override
    public byte[] encodeData(Clob value, Long maxLength) throws IOException, SQLException {
        int len;
        long remainingLen;
        ByteArrayOutputStream bb = new ByteArrayOutputStream();
        Reader reader = value.getCharacterStream();
        char[] buf = new char[4096];
        long l = remainingLen = maxLength == null ? Long.MAX_VALUE : maxLength;
        while (remainingLen > 0L && (len = reader.read(buf)) > 0) {
            byte[] data = new String(buf, 0, (int)Math.min((long)len, remainingLen)).getBytes(StandardCharsets.UTF_8);
            bb.write(data, 0, data.length);
            remainingLen -= (long)len;
        }
        return bb.toByteArray();
    }

    @Override
    public boolean canEncodeLongData() {
        return true;
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.VARSTRING.get();
    }
}

