/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.mariadb.jdbc.client.result;

import com.craftaro.third_party.org.mariadb.jdbc.Configuration;
import com.craftaro.third_party.org.mariadb.jdbc.client.ColumnDecoder;
import com.craftaro.third_party.org.mariadb.jdbc.export.ExceptionFactory;
import com.craftaro.third_party.org.mariadb.jdbc.util.constants.CatalogTerm;
import java.sql.SQLException;

public class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    private final ExceptionFactory exceptionFactory;
    private final ColumnDecoder[] fieldPackets;
    private final Configuration conf;
    private final boolean forceAlias;

    public ResultSetMetaData(ExceptionFactory exceptionFactory, ColumnDecoder[] fieldPackets, Configuration conf, boolean forceAlias) {
        this.exceptionFactory = exceptionFactory;
        this.fieldPackets = fieldPackets;
        this.conf = conf;
        this.forceAlias = forceAlias;
    }

    @Override
    public int getColumnCount() {
        return this.fieldPackets.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return (this.getColumn(column).getFlags() & 0x200) != 0;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return true;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if ((this.getColumn(column).getFlags() & 1) == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumn(column).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumn(column).getDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumn(column).getColumnAlias();
    }

    @Override
    public String getColumnName(int idx) throws SQLException {
        ColumnDecoder column = this.getColumn(idx);
        String columnName = column.getColumnName();
        if ("".equals(columnName) || this.forceAlias) {
            return column.getColumnAlias();
        }
        return columnName;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        if (this.conf.useCatalogTerm() == CatalogTerm.UseSchema) {
            return this.getColumn(column).getCatalog();
        }
        return this.getColumn(column).getSchema();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumn(column).getPrecision();
    }

    @Override
    public int getScale(int index) throws SQLException {
        return this.getColumn(index).getDecimals();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        if (this.forceAlias) {
            return this.getColumn(column).getTableAlias();
        }
        if (this.conf.blankTableNameMeta()) {
            return "";
        }
        return this.getColumn(column).getTable();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        if (this.conf.useCatalogTerm() == CatalogTerm.UseSchema) {
            return this.getColumn(column).getSchema();
        }
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getColumn(column).getColumnType(this.conf);
    }

    @Override
    public String getColumnTypeName(int index) throws SQLException {
        return this.getColumn(index).getColumnTypeName(this.conf);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        ColumnDecoder ci = this.getColumn(column);
        return ci.getColumnName().isEmpty();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getColumn(column).defaultClassname(this.conf);
    }

    private ColumnDecoder getColumn(int column) throws SQLException {
        if (column >= 1 && column <= this.fieldPackets.length) {
            return this.fieldPackets[column - 1];
        }
        throw this.exceptionFactory.create(String.format("wrong column index %s", column));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("The receiver is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }
}

