/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.mariadb.jdbc.client.context;

import com.craftaro.third_party.org.mariadb.jdbc.Configuration;
import com.craftaro.third_party.org.mariadb.jdbc.HostAddress;
import com.craftaro.third_party.org.mariadb.jdbc.client.PrepareCache;
import com.craftaro.third_party.org.mariadb.jdbc.client.context.BaseContext;
import com.craftaro.third_party.org.mariadb.jdbc.client.impl.TransactionSaver;
import com.craftaro.third_party.org.mariadb.jdbc.export.ExceptionFactory;
import com.craftaro.third_party.org.mariadb.jdbc.message.ClientMessage;
import com.craftaro.third_party.org.mariadb.jdbc.message.client.RedoableClientMessage;
import com.craftaro.third_party.org.mariadb.jdbc.message.server.InitialHandshakePacket;

public class RedoContext
extends BaseContext {
    private final TransactionSaver transactionSaver;

    public RedoContext(HostAddress hostAddress, InitialHandshakePacket handshake, long clientCapabilities, Configuration conf, ExceptionFactory exceptionFactory, PrepareCache prepareCache) {
        super(hostAddress, handshake, clientCapabilities, conf, exceptionFactory, prepareCache);
        this.transactionSaver = new TransactionSaver(conf.transactionReplaySize());
    }

    @Override
    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
        if ((serverStatus & 1) == 0) {
            this.transactionSaver.clear();
        }
    }

    public void saveRedo(ClientMessage msg) {
        if (msg instanceof RedoableClientMessage) {
            RedoableClientMessage redoMsg = (RedoableClientMessage)msg;
            redoMsg.saveParameters();
            this.transactionSaver.add(redoMsg);
        }
    }

    public void saveRedo(ClientMessage[] msgs) {
        for (ClientMessage msg : msgs) {
            this.saveRedo(msg);
        }
    }

    public TransactionSaver getTransactionSaver() {
        return this.transactionSaver;
    }
}

