/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.tools.jdbc;

import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.tools.JooqLogger;
import java.io.Closeable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Statement;
import org.jetbrains.annotations.NotNull;

public class JDBCUtils {
    private static final JooqLogger log = JooqLogger.getLogger(JDBCUtils.class);

    @NotNull
    public static final SQLDialect dialect(Connection connection) {
        SQLDialect result = SQLDialect.DEFAULT;
        if (connection != null) {
            try {
                DatabaseMetaData m = connection.getMetaData();
                String url = m.getURL();
                int majorVersion = 0;
                int minorVersion = 0;
                try {
                    majorVersion = m.getDatabaseMajorVersion();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    minorVersion = m.getDatabaseMinorVersion();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                result = JDBCUtils.dialect(url, majorVersion, minorVersion);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (result == SQLDialect.DEFAULT) {
            // empty if block
        }
        return result;
    }

    @NotNull
    private static final SQLDialect dialect(String url, int majorVersion, int minorVersion) {
        SQLDialect dialect = JDBCUtils.dialect(url);
        if (majorVersion == 0) {
            return dialect;
        }
        switch (dialect.family()) {
            case FIREBIRD: {
                return JDBCUtils.firebirdDialect(majorVersion);
            }
            case MARIADB: {
                return JDBCUtils.mariadbDialect(majorVersion, minorVersion);
            }
            case MYSQL: {
                return JDBCUtils.mysqlDialect(majorVersion);
            }
            case POSTGRES: {
                return JDBCUtils.postgresDialect(majorVersion, minorVersion);
            }
        }
        return dialect;
    }

    private static final SQLDialect postgresDialect(int majorVersion, int minorVersion) {
        return SQLDialect.POSTGRES;
    }

    private static final SQLDialect mariadbDialect(int majorVersion, int minorVersion) {
        return SQLDialect.MARIADB;
    }

    private static final SQLDialect mysqlDialect(int majorVersion) {
        return SQLDialect.MYSQL;
    }

    private static final SQLDialect firebirdDialect(int majorVersion) {
        return SQLDialect.FIREBIRD;
    }

    @NotNull
    public static final SQLDialect dialect(String url) {
        if (url == null) {
            return SQLDialect.DEFAULT;
        }
        if (url.contains(":cubrid:")) {
            return SQLDialect.CUBRID;
        }
        if (url.contains(":derby:")) {
            return SQLDialect.DERBY;
        }
        if (url.contains(":firebirdsql:")) {
            return SQLDialect.FIREBIRD;
        }
        if (url.contains(":h2:")) {
            return SQLDialect.H2;
        }
        if (url.contains(":hsqldb:")) {
            return SQLDialect.HSQLDB;
        }
        if (url.contains(":mariadb:")) {
            return SQLDialect.MARIADB;
        }
        if (url.contains(":mysql:") || url.contains(":google:")) {
            return SQLDialect.MYSQL;
        }
        if (url.contains(":postgresql:") || url.contains(":pgsql:")) {
            return SQLDialect.POSTGRES;
        }
        if (url.contains(":sqlite:") || url.contains(":sqldroid:")) {
            return SQLDialect.SQLITE;
        }
        return SQLDialect.DEFAULT;
    }

    @NotNull
    public static final String driver(SQLDialect dialect) {
        switch (dialect.family()) {
            case CUBRID: {
                return "cubrid.jdbc.driver.CUBRIDDriver";
            }
            case DERBY: {
                return "org.apache.derby.jdbc.ClientDriver";
            }
            case FIREBIRD: {
                return "org.firebirdsql.jdbc.FBDriver";
            }
            case H2: {
                return "com.craftaro.third_party.org.h2.Driver";
            }
            case HSQLDB: {
                return "org.hsqldb.jdbcDriver";
            }
            case MARIADB: {
                return "com.craftaro.third_party.org.mariadb.jdbc.Driver";
            }
            case MYSQL: {
                return "com.mysql.cj.jdbc.Driver";
            }
            case POSTGRES: {
                return "org.postgresql.Driver";
            }
            case SQLITE: {
                return "org.sqlite.JDBC";
            }
        }
        return "java.sql.Driver";
    }

    @NotNull
    public static final String driver(String url) {
        return JDBCUtils.driver(JDBCUtils.dialect(url).family());
    }

    public static final void safeClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void safeClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void safeClose(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void safeClose(ResultSet resultSet, PreparedStatement statement) {
        JDBCUtils.safeClose(resultSet);
        JDBCUtils.safeClose(statement);
    }

    public static final void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void safeClose(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void safeFree(Blob blob) {
        if (blob != null) {
            try {
                blob.free();
            }
            catch (Exception ignore) {
                log.warn((Object)"Error while freeing resource", ignore);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
    }

    public static final void safeFree(Clob clob) {
        if (clob != null) {
            try {
                clob.free();
            }
            catch (Exception ignore) {
                log.warn((Object)"Error while freeing resource", ignore);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
    }

    public static final void safeFree(SQLXML xml) {
        if (xml != null) {
            try {
                xml.free();
            }
            catch (Exception ignore) {
                log.warn((Object)"Error while freeing resource", ignore);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
    }

    public static final void safeFree(Array array) {
        if (array != null) {
            try {
                array.free();
            }
            catch (Exception ignore) {
                log.warn((Object)"Error while freeing resource", ignore);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
    }

    public static final <T> T wasNull(SQLInput stream, T value) throws SQLException {
        return value == null || stream.wasNull() ? null : (T)value;
    }

    public static final <T extends Number> T wasNull(SQLInput stream, T value) throws SQLException {
        return value == null || value.intValue() == 0 && stream.wasNull() ? null : (T)value;
    }

    public static final Boolean wasNull(SQLInput stream, Boolean value) throws SQLException {
        return value == null || value == false && stream.wasNull() ? null : value;
    }

    public static final <T> T wasNull(ResultSet rs, T value) throws SQLException {
        return value == null || rs.wasNull() ? null : (T)value;
    }

    public static final <T extends Number> T wasNull(ResultSet rs, T value) throws SQLException {
        return value == null || value.intValue() == 0 && rs.wasNull() ? null : (T)value;
    }

    public static final Boolean wasNull(ResultSet rs, Boolean value) throws SQLException {
        return value == null || value == false && rs.wasNull() ? null : value;
    }

    public static final <T> T wasNull(CallableStatement statement, T value) throws SQLException {
        return value == null || statement.wasNull() ? null : (T)value;
    }

    public static final <T extends Number> T wasNull(CallableStatement statement, T value) throws SQLException {
        return value == null || value.intValue() == 0 && statement.wasNull() ? null : (T)value;
    }

    public static final Boolean wasNull(CallableStatement statement, Boolean value) throws SQLException {
        return value == null || value == false && statement.wasNull() ? null : value;
    }

    private JDBCUtils() {
    }
}

