/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.DataType;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.XML;
import com.craftaro.third_party.org.jooq.XMLAttributes;
import com.craftaro.third_party.org.jooq.impl.AbstractField;
import com.craftaro.third_party.org.jooq.impl.F1;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Names;
import com.craftaro.third_party.org.jooq.impl.QueryPartCollectionView;
import com.craftaro.third_party.org.jooq.impl.QueryPartList;
import com.craftaro.third_party.org.jooq.impl.SQLDataType;
import com.craftaro.third_party.org.jooq.impl.Tools;
import com.craftaro.third_party.org.jooq.impl.XMLAttributesImpl;
import java.util.Collection;

final class XMLElement
extends AbstractField<XML> {
    private static final long serialVersionUID = 4505809303211506197L;
    private final Name elementName;
    private final XMLAttributes attributes;
    private final QueryPartList<Field<?>> content;

    XMLElement(Name elementName, XMLAttributes attributes, Collection<? extends Field<?>> content) {
        super(Names.N_XMLELEMENT, SQLDataType.XML);
        this.elementName = elementName;
        this.attributes = attributes;
        this.content = new QueryPartList((Iterable<Field<?>>)content);
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean hasAttributes = this.attributes != null && !((XMLAttributesImpl)this.attributes).attributes.isEmpty();
        boolean hasContent = !this.content.isEmpty();
        boolean format = hasAttributes || hasContent;
        Object previous = ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED);
        ctx.visit(Names.N_XMLELEMENT).sql('(');
        if (format) {
            ctx.formatIndentStart().formatNewLine();
            ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, true);
        }
        ctx.visit(Keywords.K_NAME).sql(' ').visit(this.elementName);
        if (hasAttributes) {
            if (format) {
                ctx.sql(',').formatSeparator().visit(this.attributes);
            } else {
                ctx.sql(", ").visit(this.attributes);
            }
        }
        if (hasContent) {
            if (format) {
                ctx.sql(',').formatSeparator().visit(QueryPartCollectionView.wrap(this.content).map(XMLElement.xmlCastMapper(ctx)));
            } else {
                ctx.sql(", ").visit(QueryPartCollectionView.wrap(this.content).map(XMLElement.xmlCastMapper(ctx)));
            }
        }
        if (format) {
            ctx.formatIndentEnd().formatNewLine();
            ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, previous);
        }
        ctx.sql(')');
    }

    static final F1<? super Field<?>, ? extends Field<?>> xmlCastMapper(final Context<?> ctx) {
        return new F1<Field<?>, Field<?>>(){

            @Override
            public Field<?> apply(Field<?> field) {
                return XMLElement.xmlCast(ctx, field);
            }
        };
    }

    static final Field<?> xmlCast(Context<?> ctx, Field<?> field) {
        Field<?> result = field;
        DataType type = field.getDataType();
        switch (ctx.family()) {
            default: 
        }
        if (result != field && Tools.aliased(field) != null) {
            return result.as(field);
        }
        return result;
    }
}

