/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Field;
import com.craftaro.third_party.org.jooq.Keyword;
import com.craftaro.third_party.org.jooq.OrderField;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.WindowSpecificationExcludeStep;
import com.craftaro.third_party.org.jooq.WindowSpecificationFinalStep;
import com.craftaro.third_party.org.jooq.WindowSpecificationOrderByStep;
import com.craftaro.third_party.org.jooq.WindowSpecificationPartitionByStep;
import com.craftaro.third_party.org.jooq.WindowSpecificationRowsAndStep;
import com.craftaro.third_party.org.jooq.impl.AbstractQueryPart;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.QueryPartList;
import com.craftaro.third_party.org.jooq.impl.SortFieldList;
import com.craftaro.third_party.org.jooq.impl.Tools;
import com.craftaro.third_party.org.jooq.impl.WindowDefinitionImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

final class WindowSpecificationImpl
extends AbstractQueryPart
implements WindowSpecificationPartitionByStep,
WindowSpecificationRowsAndStep,
WindowSpecificationExcludeStep {
    private static final long serialVersionUID = 2996016924769376361L;
    private static final Set<SQLDialect> OMIT_PARTITION_BY_ONE = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private final WindowDefinitionImpl windowDefinition;
    private final QueryPartList<Field<?>> partitionBy;
    private final SortFieldList orderBy;
    private Integer frameStart;
    private Integer frameEnd;
    private FrameUnits frameUnits;
    private Exclude exclude;
    private boolean partitionByOne;

    WindowSpecificationImpl() {
        this(null);
    }

    WindowSpecificationImpl(WindowDefinitionImpl windowDefinition) {
        this.windowDefinition = windowDefinition;
        this.partitionBy = new QueryPartList();
        this.orderBy = new SortFieldList();
    }

    WindowSpecificationImpl copy() {
        WindowSpecificationImpl copy = new WindowSpecificationImpl(this.windowDefinition);
        copy.partitionBy.addAll((Collection<Field<?>>)this.partitionBy);
        copy.orderBy.addAll(this.orderBy);
        copy.frameStart = this.frameStart;
        copy.frameEnd = this.frameEnd;
        copy.frameUnits = this.frameUnits;
        copy.exclude = this.exclude;
        copy.partitionByOne = this.partitionByOne;
        return copy;
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean indent;
        SortFieldList o = this.orderBy;
        if (o.isEmpty() && Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_WINDOW_FUNCTION_REQUIRES_ORDER_BY))) {
            Field<Integer> constant = DSL.field(DSL.select(DSL.one()));
            o = new SortFieldList();
            o.add(constant.sortDefault());
        }
        boolean hasWindowDefinitions = this.windowDefinition != null;
        boolean hasPartitionBy = !this.partitionBy.isEmpty();
        boolean hasOrderBy = !o.isEmpty();
        boolean hasFrame = this.frameStart != null;
        int clauses = 0;
        if (hasWindowDefinitions) {
            ++clauses;
        }
        if (hasPartitionBy) {
            ++clauses;
        }
        if (hasOrderBy) {
            ++clauses;
        }
        if (hasFrame) {
            ++clauses;
        }
        boolean bl = indent = clauses > 1;
        if (indent) {
            ctx.formatIndentStart().formatNewLine();
        }
        if (this.windowDefinition != null) {
            boolean declareWindows = ctx.declareWindows();
            ctx.declareWindows(false).visit(this.windowDefinition).declareWindows(declareWindows);
        }
        if (!(!hasPartitionBy || this.partitionByOne && OMIT_PARTITION_BY_ONE.contains((Object)ctx.dialect()))) {
            if (hasWindowDefinitions) {
                ctx.formatSeparator();
            }
            ctx.visit(Keywords.K_PARTITION_BY).separatorRequired(true).visit(this.partitionBy);
        }
        if (hasOrderBy) {
            if (hasWindowDefinitions || hasPartitionBy) {
                ctx.formatSeparator();
            }
            ctx.visit(Keywords.K_ORDER_BY).separatorRequired(true).visit(o);
        }
        if (hasFrame) {
            if (hasWindowDefinitions || hasPartitionBy || hasOrderBy) {
                ctx.formatSeparator();
            }
            ctx.visit(this.frameUnits.keyword).sql(' ');
            if (this.frameEnd != null) {
                ctx.visit(Keywords.K_BETWEEN).sql(' ');
                this.toSQLRows(ctx, this.frameStart);
                ctx.sql(' ').visit(Keywords.K_AND).sql(' ');
                this.toSQLRows(ctx, this.frameEnd);
            } else {
                this.toSQLRows(ctx, this.frameStart);
            }
            if (this.exclude != null) {
                ctx.sql(' ').visit(Keywords.K_EXCLUDE).sql(' ').visit(this.exclude.keyword);
            }
        }
        if (indent) {
            ctx.formatIndentEnd().formatNewLine();
        }
    }

    private final void toSQLRows(Context<?> ctx, Integer rows) {
        if (rows == Integer.MIN_VALUE) {
            ctx.visit(Keywords.K_UNBOUNDED_PRECEDING);
        } else if (rows == Integer.MAX_VALUE) {
            ctx.visit(Keywords.K_UNBOUNDED_FOLLOWING);
        } else if (rows < 0) {
            ctx.sql(-rows.intValue()).sql(' ').visit(Keywords.K_PRECEDING);
        } else if (rows > 0) {
            ctx.sql(rows).sql(' ').visit(Keywords.K_FOLLOWING);
        } else {
            ctx.visit(Keywords.K_CURRENT_ROW);
        }
    }

    @Override
    public final WindowSpecificationPartitionByStep partitionBy(Field<?> ... fields) {
        return this.partitionBy(Arrays.asList(fields));
    }

    @Override
    public final WindowSpecificationPartitionByStep partitionBy(Collection<? extends Field<?>> fields) {
        this.partitionBy.addAll((Collection<Field<?>>)fields);
        return this;
    }

    @Override
    @Deprecated
    public final WindowSpecificationOrderByStep partitionByOne() {
        this.partitionByOne = true;
        this.partitionBy.add((Field<?>)DSL.one());
        return this;
    }

    @Override
    public final WindowSpecificationOrderByStep orderBy(OrderField<?> ... fields) {
        return this.orderBy(Arrays.asList(fields));
    }

    @Override
    public final WindowSpecificationOrderByStep orderBy(Collection<? extends OrderField<?>> fields) {
        this.orderBy.addAll(Tools.sortFields(fields));
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rowsUnboundedPreceding() {
        this.frameUnits = FrameUnits.ROWS;
        this.frameStart = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rowsPreceding(int number) {
        this.frameUnits = FrameUnits.ROWS;
        this.frameStart = -number;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rowsCurrentRow() {
        this.frameUnits = FrameUnits.ROWS;
        this.frameStart = 0;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rowsUnboundedFollowing() {
        this.frameUnits = FrameUnits.ROWS;
        this.frameStart = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rowsFollowing(int number) {
        this.frameUnits = FrameUnits.ROWS;
        this.frameStart = number;
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenUnboundedPreceding() {
        this.rowsUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenPreceding(int number) {
        this.rowsPreceding(number);
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenCurrentRow() {
        this.rowsCurrentRow();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenUnboundedFollowing() {
        this.rowsUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rowsBetweenFollowing(int number) {
        this.rowsFollowing(number);
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rangeUnboundedPreceding() {
        this.frameUnits = FrameUnits.RANGE;
        this.frameStart = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rangePreceding(int number) {
        this.frameUnits = FrameUnits.RANGE;
        this.frameStart = -number;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rangeCurrentRow() {
        this.frameUnits = FrameUnits.RANGE;
        this.frameStart = 0;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rangeUnboundedFollowing() {
        this.frameUnits = FrameUnits.RANGE;
        this.frameStart = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep rangeFollowing(int number) {
        this.frameUnits = FrameUnits.RANGE;
        this.frameStart = number;
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenUnboundedPreceding() {
        this.rangeUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenPreceding(int number) {
        this.rangePreceding(number);
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenCurrentRow() {
        this.rangeCurrentRow();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenUnboundedFollowing() {
        this.rangeUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep rangeBetweenFollowing(int number) {
        this.rangeFollowing(number);
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep groupsUnboundedPreceding() {
        this.frameUnits = FrameUnits.GROUPS;
        this.frameStart = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep groupsPreceding(int number) {
        this.frameUnits = FrameUnits.GROUPS;
        this.frameStart = -number;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep groupsCurrentRow() {
        this.frameUnits = FrameUnits.GROUPS;
        this.frameStart = 0;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep groupsUnboundedFollowing() {
        this.frameUnits = FrameUnits.GROUPS;
        this.frameStart = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep groupsFollowing(int number) {
        this.frameUnits = FrameUnits.GROUPS;
        this.frameStart = number;
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep groupsBetweenUnboundedPreceding() {
        this.groupsUnboundedPreceding();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep groupsBetweenPreceding(int number) {
        this.groupsPreceding(number);
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep groupsBetweenCurrentRow() {
        this.groupsCurrentRow();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep groupsBetweenUnboundedFollowing() {
        this.groupsUnboundedFollowing();
        return this;
    }

    @Override
    public final WindowSpecificationRowsAndStep groupsBetweenFollowing(int number) {
        this.groupsFollowing(number);
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep andUnboundedPreceding() {
        this.frameEnd = Integer.MIN_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep andPreceding(int number) {
        this.frameEnd = -number;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep andCurrentRow() {
        this.frameEnd = 0;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep andUnboundedFollowing() {
        this.frameEnd = Integer.MAX_VALUE;
        return this;
    }

    @Override
    public final WindowSpecificationExcludeStep andFollowing(int number) {
        this.frameEnd = number;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep excludeCurrentRow() {
        this.exclude = Exclude.CURRENT_ROW;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep excludeGroup() {
        this.exclude = Exclude.GROUP;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep excludeTies() {
        this.exclude = Exclude.TIES;
        return this;
    }

    @Override
    public final WindowSpecificationFinalStep excludeNoOthers() {
        this.exclude = Exclude.NO_OTHERS;
        return this;
    }

    static enum Exclude {
        CURRENT_ROW("current row"),
        TIES("ties"),
        GROUP("group"),
        NO_OTHERS("no others");

        final Keyword keyword;

        private Exclude(String keyword) {
            this.keyword = DSL.keyword(keyword);
        }
    }

    static enum FrameUnits {
        ROWS("rows"),
        RANGE("range"),
        GROUPS("groups");

        final Keyword keyword;

        private FrameUnits(String keyword) {
            this.keyword = DSL.keyword(keyword);
        }
    }
}

