/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.DDLQuery;
import com.craftaro.third_party.org.jooq.DSLContext;
import com.craftaro.third_party.org.jooq.Meta;
import com.craftaro.third_party.org.jooq.Queries;
import com.craftaro.third_party.org.jooq.Query;
import com.craftaro.third_party.org.jooq.Source;
import com.craftaro.third_party.org.jooq.Version;
import com.craftaro.third_party.org.jooq.conf.InterpreterSearchSchema;
import com.craftaro.third_party.org.jooq.exception.DataDefinitionException;
import com.craftaro.third_party.org.jooq.impl.DSL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class VersionImpl
implements Version {
    private final DSLContext ctx;
    private final String id;
    private final Meta meta;
    private final List<Parent> parents;

    private VersionImpl(DSLContext ctx, String id, Meta meta, List<Parent> parents) {
        this.ctx = ctx;
        this.id = id;
        this.meta = meta != null ? meta : VersionImpl.init(ctx);
        this.parents = parents;
    }

    private static final Meta init(DSLContext ctx) {
        Meta result = ctx.meta("");
        List<InterpreterSearchSchema> searchPath = ctx.settings().getInterpreterSearchPath();
        for (InterpreterSearchSchema schema : searchPath) {
            result = result.apply(DSL.createSchema(DSL.schema(DSL.name(schema.getCatalog(), schema.getSchema()))));
        }
        return result;
    }

    VersionImpl(DSLContext ctx, String id, Meta meta, Version parent, Queries queries) {
        this(ctx, id, meta, Arrays.asList(new Parent((VersionImpl)parent, queries)));
    }

    VersionImpl(DSLContext ctx, String id, Meta meta, Version[] parents) {
        this(ctx, id, meta, VersionImpl.wrap(parents));
    }

    private static List<Parent> wrap(Version[] parents) {
        ArrayList<Parent> result = new ArrayList<Parent>(parents.length);
        for (Version parent : parents) {
            result.add(new Parent((VersionImpl)parent, null));
        }
        return result;
    }

    @Override
    public final String id() {
        return this.id;
    }

    @Override
    public final Meta meta() {
        return this.meta;
    }

    @Override
    public final Version root() {
        VersionImpl result = this;
        while (result.parents.size() > 0) {
            result = result.parents.get((int)0).version;
        }
        return result;
    }

    @Override
    public final List<Version> parents() {
        ArrayList<VersionImpl> result = new ArrayList<VersionImpl>(this.parents.size());
        for (Parent parent : this.parents) {
            result.add(parent.version);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public final Version apply(String newId, Query ... migration) {
        return this.apply(newId, this.ctx.queries(migration));
    }

    @Override
    public final Version apply(String newId, Collection<? extends Query> migration) {
        return this.apply(newId, this.ctx.queries(migration));
    }

    @Override
    public final Version apply(String newId, String migration) {
        return this.apply(newId, this.ctx.parser().parse(migration));
    }

    @Override
    public final Version apply(String newId, Queries migration) {
        return new VersionImpl(this.ctx, newId, this.meta().apply(migration), this, migration);
    }

    @Override
    public final Queries migrateTo(Version version) {
        if (this.equals(version)) {
            return this.ctx.queries(new Query[0]);
        }
        VersionImpl subgraph = ((VersionImpl)version).subgraphTo(this);
        if (subgraph == null) {
            throw new DataDefinitionException("No forward path available between versions " + this.id() + " and " + version.id() + ". Use Settings.migrationAllowsUndo to enable this feature.");
        }
        return this.migrateTo(subgraph, this.ctx.queries(new Query[0]));
    }

    private final VersionImpl subgraphTo(VersionImpl ancestor) {
        ArrayList<Parent> list = null;
        for (Parent parent : this.parents) {
            if (parent.version.equals(ancestor)) {
                if (list == null) {
                    list = new ArrayList<Parent>();
                }
                list.add(new Parent(new VersionImpl(this.ctx, parent.version.id, parent.version.meta, Collections.emptyList()), parent.queries));
                continue;
            }
            VersionImpl p = parent.version.subgraphTo(ancestor);
            if (p == null) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(new Parent(p, parent.queries));
        }
        return list == null ? null : new VersionImpl(this.ctx, this.id, this.meta, list);
    }

    private final Queries migrateTo(VersionImpl target, Queries result) {
        if (!target.forceApply()) {
            return this.meta().migrateTo(target.meta());
        }
        for (Parent parent : target.parents) {
            result = this.migrateTo(parent.version, result);
            if (!VersionImpl.forceApply(parent.queries)) {
                result = result.concat(parent.version.meta().migrateTo(target.meta()));
                continue;
            }
            result = result.concat(parent.queries);
        }
        return result;
    }

    private final boolean forceApply() {
        for (Parent parent : this.parents) {
            if (VersionImpl.forceApply(parent.queries)) {
                return true;
            }
            if (!parent.version.forceApply()) continue;
            return true;
        }
        return false;
    }

    private static final boolean forceApply(Queries queries) {
        if (queries != null) {
            for (Query query : queries.queries()) {
                if (query instanceof DDLQuery) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final Version commit(String newId, String ... newMeta) {
        return this.commit(newId, this.ctx.meta(newMeta));
    }

    @Override
    public final Version commit(String newId, Source ... newMeta) {
        return this.commit(newId, this.ctx.meta(newMeta));
    }

    @Override
    public final Version commit(String newId, Meta newMeta) {
        return new VersionImpl(this.ctx, newId, newMeta, new Version[]{this});
    }

    private static final Version commonAncestor(Version v1, Version v2) {
        if (v1.id().equals(v2.id())) {
            return v1;
        }
        Map<Version, Integer> a1 = VersionImpl.ancestors(v1, new HashMap<Version, Integer>(), 1);
        Map<Version, Integer> a2 = VersionImpl.ancestors(v2, new HashMap<Version, Integer>(), 1);
        Version version = null;
        Integer distance = null;
        for (Map.Entry<Version, Integer> entry : a1.entrySet()) {
            if (!a2.containsKey(entry.getKey()) || distance != null && distance <= entry.getValue()) continue;
            version = entry.getKey();
            distance = entry.getValue();
        }
        if (version == null) {
            throw new DataDefinitionException("Versions " + v1.id() + " and " + v2.id() + " do not have a common ancestor");
        }
        return version;
    }

    private static Map<Version, Integer> ancestors(Version v, Map<Version, Integer> result, int distance) {
        VersionImpl current = (VersionImpl)v;
        Integer previous = result.get(current);
        if (previous == null || previous > distance) {
            result.put(current, distance);
            for (Parent parent : current.parents) {
                VersionImpl.ancestors(parent.version, result, distance + 1);
            }
        }
        return result;
    }

    @Override
    public final Version merge(String newId, Version with) {
        Meta m = VersionImpl.commonAncestor(this, with).meta();
        return new VersionImpl(this.ctx, newId, m.apply(m.migrateTo(this.meta()).concat(m.migrateTo(with.meta()))), new Version[]{this, with});
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionImpl other = (VersionImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "-- Version: " + this.id() + "\n" + this.meta();
    }

    private static final class Parent {
        final VersionImpl version;
        final Queries queries;

        Parent(VersionImpl version, Queries queries) {
            this.version = version;
            this.queries = queries;
        }

        public String toString() {
            return this.version.toString();
        }
    }
}

