/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Condition;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.GroupField;
import com.craftaro.third_party.org.jooq.Select;
import com.craftaro.third_party.org.jooq.SelectHavingConditionStep;
import com.craftaro.third_party.org.jooq.Table;
import com.craftaro.third_party.org.jooq.TableLike;
import com.craftaro.third_party.org.jooq.impl.AbstractCondition;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.Keywords;
import com.craftaro.third_party.org.jooq.impl.Tools;

final class UniqueCondition
extends AbstractCondition {
    private static final long serialVersionUID = -5560973283201522844L;
    private final Select<?> query;
    private final boolean unique;

    UniqueCondition(Select<?> query, boolean unique) {
        this.query = query;
        this.unique = unique;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: {
                if (!this.unique) {
                    ctx.visit(Keywords.K_NOT).sql(' ');
                }
                ctx.visit(Keywords.K_UNIQUE).sql(' ');
                Tools.visitSubquery(ctx, this.query, true);
                break;
            }
            default: {
                Table queryTable = this.query.asTable("t");
                GroupField[] queryFields = queryTable.fields();
                SelectHavingConditionStep subquery = DSL.select(DSL.one()).from((TableLike<?>)queryTable).where(DSL.row(queryFields).isNotNull()).groupBy(queryFields).having(DSL.count().gt(DSL.one()));
                ctx.visit(this.unique ? DSL.notExists(subquery) : DSL.exists(subquery));
            }
        }
    }

    @Override
    public final Condition not() {
        return this.unique ? new UniqueCondition(this.query, false) : super.not();
    }
}

