/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Keyword;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.impl.DSL;

enum Term {
    ATAN2{

        @Override
        public String translate(SQLDialect dialect) {
            return "atan2";
        }
    }
    ,
    BIT_LENGTH{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case DERBY: 
                case SQLITE: {
                    return "8 * length";
                }
            }
            return "bit_length";
        }
    }
    ,
    CHAR_LENGTH{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case DERBY: 
                case SQLITE: {
                    return "length";
                }
            }
            return "char_length";
        }
    }
    ,
    OCTET_LENGTH{

        @Override
        public String translate(SQLDialect dialect) {
            switch (dialect.family()) {
                case DERBY: 
                case SQLITE: {
                    return "length";
                }
            }
            return "octet_length";
        }
    }
    ,
    STDDEV_POP{

        @Override
        public String translate(SQLDialect dialect) {
            return "stddev_pop";
        }
    }
    ,
    STDDEV_SAMP{

        @Override
        public String translate(SQLDialect dialect) {
            return "stddev_samp";
        }
    }
    ,
    VAR_POP{

        @Override
        public String translate(SQLDialect dialect) {
            return "var_pop";
        }
    }
    ,
    VAR_SAMP{

        @Override
        public String translate(SQLDialect dialect) {
            return "var_samp";
        }
    };

    private final Name name = DSL.unquotedName(this.name());
    private final Keyword keyword = DSL.keyword(this.name());
    private final String translation = this.name().toLowerCase();

    public String toString() {
        return super.toString();
    }

    public final Name toName() {
        return this.name;
    }

    public Keyword toKeyword() {
        return this.keyword;
    }

    String translate(SQLDialect dialect) {
        return this.translation;
    }
}

