/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.conf.Settings;
import com.craftaro.third_party.org.jooq.conf.SettingsTools;
import com.craftaro.third_party.org.jooq.impl.SettingsEnabledPreparedStatement;
import com.craftaro.third_party.org.jooq.tools.jdbc.DefaultConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

final class SettingsEnabledConnection
extends DefaultConnection {
    private final Settings settings;

    SettingsEnabledConnection(Connection delegate, Settings settings) {
        super(delegate);
        this.settings = settings;
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        if (SettingsTools.executePreparedStatements(this.settings)) {
            return this.getDelegate().prepareStatement(sql);
        }
        return new SettingsEnabledPreparedStatement(this.getDelegate(), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (SettingsTools.executePreparedStatements(this.settings)) {
            return this.getDelegate().prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        return new SettingsEnabledPreparedStatement(this.getDelegate(), sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (SettingsTools.executePreparedStatements(this.settings)) {
            return this.getDelegate().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return new SettingsEnabledPreparedStatement(this.getDelegate(), sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (SettingsTools.executePreparedStatements(this.settings)) {
            return this.getDelegate().prepareStatement(sql, autoGeneratedKeys);
        }
        return new SettingsEnabledPreparedStatement(this.getDelegate(), sql, autoGeneratedKeys);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (SettingsTools.executePreparedStatements(this.settings)) {
            return this.getDelegate().prepareStatement(sql, columnIndexes);
        }
        return new SettingsEnabledPreparedStatement(this.getDelegate(), sql, columnIndexes);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (SettingsTools.executePreparedStatements(this.settings)) {
            return this.getDelegate().prepareStatement(sql, columnNames);
        }
        return new SettingsEnabledPreparedStatement(this.getDelegate(), sql, columnNames);
    }
}

