/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Comparator;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.Name;
import com.craftaro.third_party.org.jooq.QuantifiedSelect;
import com.craftaro.third_party.org.jooq.QueryPartInternal;
import com.craftaro.third_party.org.jooq.Record;
import com.craftaro.third_party.org.jooq.RenderContext;
import com.craftaro.third_party.org.jooq.Row;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.Select;
import com.craftaro.third_party.org.jooq.SelectFieldOrAsterisk;
import com.craftaro.third_party.org.jooq.SelectOrderByStep;
import com.craftaro.third_party.org.jooq.TableLike;
import com.craftaro.third_party.org.jooq.impl.AbstractCondition;
import com.craftaro.third_party.org.jooq.impl.AliasedSelect;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.QuantifiedSelectImpl;
import com.craftaro.third_party.org.jooq.impl.Quantifier;
import com.craftaro.third_party.org.jooq.impl.RowCondition;
import com.craftaro.third_party.org.jooq.impl.Tools;
import java.util.Set;

final class RowSubqueryCondition
extends AbstractCondition {
    private static final long serialVersionUID = -1806139685201770706L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_COMPARISON};
    private static final Set<SQLDialect> SUPPORT_NATIVE = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE);
    private static final Set<SQLDialect> NO_SUPPORT_NATIVE_QUANTIFIED = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private final Row left;
    private final Select<?> right;
    private final QuantifiedSelect<?> rightQuantified;
    private final Comparator comparator;

    RowSubqueryCondition(Row left, Select<?> right, Comparator comparator) {
        this.left = left;
        this.right = right;
        this.rightQuantified = null;
        this.comparator = comparator;
    }

    RowSubqueryCondition(Row left, QuantifiedSelect<?> right, Comparator comparator) {
        this.left = left;
        this.right = null;
        this.rightQuantified = right;
        this.comparator = comparator;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.delegate(ctx));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    private final QueryPartInternal delegate(Context<?> ctx) {
        if (this.rightQuantified != null) {
            if (NO_SUPPORT_NATIVE_QUANTIFIED.contains((Object)ctx.dialect())) {
                QuantifiedSelectImpl q = (QuantifiedSelectImpl)this.rightQuantified;
                switch (this.comparator) {
                    case EQUALS: 
                    case NOT_EQUALS: {
                        if (this.comparator == Comparator.NOT_EQUALS ^ q.quantifier == Quantifier.ALL) {
                            return RowSubqueryCondition.emulationUsingExists(ctx, this.left, q.query, this.comparator == Comparator.EQUALS ? Comparator.NOT_EQUALS : Comparator.EQUALS, this.comparator == Comparator.EQUALS);
                        }
                        return new RowSubqueryCondition(this.left, q.query, this.comparator == Comparator.EQUALS ? Comparator.IN : Comparator.NOT_IN);
                    }
                }
                return RowSubqueryCondition.emulationUsingExists(ctx, this.left, q.query, q.quantifier == Quantifier.ALL ? this.comparator.inverse() : this.comparator, q.quantifier == Quantifier.ALL);
            }
            return new Native();
        }
        if (SUPPORT_NATIVE.contains((Object)ctx.dialect())) {
            return new Native();
        }
        return RowSubqueryCondition.emulationUsingExists(ctx, this.left, this.right, this.comparator == Comparator.GREATER || this.comparator == Comparator.GREATER_OR_EQUAL || this.comparator == Comparator.LESS || this.comparator == Comparator.LESS_OR_EQUAL ? this.comparator : Comparator.EQUALS, this.comparator == Comparator.NOT_IN || this.comparator == Comparator.NOT_EQUALS);
    }

    private static final QueryPartInternal emulationUsingExists(Context<?> ctx, Row row, Select<?> select, Comparator comparator, boolean notExists) {
        SelectOrderByStep<Record> subselect = RowSubqueryCondition.emulatedSubselect(ctx, row, select, comparator);
        return (QueryPartInternal)((Object)(notExists ? DSL.notExists(subselect) : DSL.exists(subselect)));
    }

    private static final SelectOrderByStep<Record> emulatedSubselect(Context<?> ctx, Row row, Select<?> s, Comparator c2) {
        RenderContext render = ctx instanceof RenderContext ? (RenderContext)ctx : null;
        Row l = Tools.embeddedFieldsRow(row);
        Name table = DSL.name(render == null ? "t" : render.nextAlias());
        Name[] names = Tools.fieldNames(l.size());
        return DSL.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)new AliasedSelect(s, names).as(table)).where(c2 == null ? DSL.noCondition() : new RowCondition(l, DSL.row(Tools.fieldsByName(table, names)), c2));
    }

    private class Native
    extends AbstractCondition {
        private static final long serialVersionUID = -1552476981094856727L;

        private Native() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(RowSubqueryCondition.this.left).sql(' ').visit(RowSubqueryCondition.this.comparator.toKeyword()).sql(' ');
            if (RowSubqueryCondition.this.rightQuantified == null) {
                boolean extraParentheses = false;
                ctx.sql(extraParentheses ? "((" : "(");
                Tools.visitSubquery(ctx, RowSubqueryCondition.this.right);
                ctx.sql(extraParentheses ? "))" : ")");
            } else {
                ctx.subquery(true).visit(RowSubqueryCondition.this.rightQuantified).subquery(false);
            }
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return CLAUSES;
        }
    }
}

