/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.jooq.impl;

import com.craftaro.third_party.org.jooq.Clause;
import com.craftaro.third_party.org.jooq.Comparator;
import com.craftaro.third_party.org.jooq.Condition;
import com.craftaro.third_party.org.jooq.Configuration;
import com.craftaro.third_party.org.jooq.Context;
import com.craftaro.third_party.org.jooq.QueryPartInternal;
import com.craftaro.third_party.org.jooq.Row;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.impl.AbstractCondition;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.craftaro.third_party.org.jooq.impl.InCondition;
import com.craftaro.third_party.org.jooq.impl.QueryPartList;
import com.craftaro.third_party.org.jooq.impl.QueryPartListView;
import com.craftaro.third_party.org.jooq.impl.RowCondition;
import java.util.ArrayList;
import java.util.Set;

final class RowInCondition
extends AbstractCondition {
    private static final long serialVersionUID = -1806139685201770706L;
    private static final Clause[] CLAUSES_IN = new Clause[]{Clause.CONDITION, Clause.CONDITION_IN};
    private static final Clause[] CLAUSES_IN_NOT = new Clause[]{Clause.CONDITION, Clause.CONDITION_NOT_IN};
    private static final Set<SQLDialect> EMULATE_IN = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.SQLITE);
    private final Row left;
    private final QueryPartList<? extends Row> right;
    private final boolean not;

    RowInCondition(Row left, QueryPartList<? extends Row> right, boolean not) {
        this.left = left;
        this.right = right;
        this.not = not;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.delegate(ctx.configuration()));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    private final QueryPartInternal delegate(Configuration configuration) {
        if (EMULATE_IN.contains((Object)configuration.dialect())) {
            ArrayList<RowCondition> conditions = new ArrayList<RowCondition>(this.right.size());
            for (Row row : this.right) {
                conditions.add(new RowCondition(this.left, row, Comparator.EQUALS));
            }
            Condition result = DSL.or(conditions);
            if (this.not) {
                result = result.not();
            }
            return (QueryPartInternal)((Object)result);
        }
        return new Native();
    }

    private class Native
    extends AbstractCondition {
        private static final long serialVersionUID = -7019193803316281371L;

        private Native() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            if (RowInCondition.this.right.size() == 0) {
                if (RowInCondition.this.not) {
                    ctx.visit(DSL.trueCondition());
                } else {
                    ctx.visit(DSL.falseCondition());
                }
            } else {
                ctx.visit(RowInCondition.this.left).sql(' ').visit((RowInCondition.this.not ? Comparator.NOT_IN : Comparator.IN).toKeyword()).sql(" (").visit(new QueryPartListView(InCondition.padded(ctx, RowInCondition.this.right))).sql(')');
            }
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return RowInCondition.this.not ? CLAUSES_IN_NOT : CLAUSES_IN;
        }
    }
}

